/**
 * Zephyr New Message UI Controller
 **
 * Wilfredo Sanchez | wsanchez@apple.com
 * Copyright 1998 Apple Computer, Inc.
 * All rights reserved.
 **/

#import <Foundation/NSObject.h>

@class NSWindow;
@class NSForm;
@class NSMatrix;
@class NSButton;
@class NSPopUpButton;
@class NSTextView;
@class NSTextField;

@class ZephyrMessage;

@interface NewMessageController : NSObject

{
@private
    ////
    // IB Outlets
    ////
#ifdef _IB_
    id window;
    id destinationForm;
    id classCell;
    id instanceCell;
    id recipientCell;
    id sendToMatrix;
    id urgentButton;
    id authenticateButton;
    id favoritesPopUp;
    id recentPopUp;
    id replyPopUp;
    id findButton;
    id sendButton;
    id messageTextView;
    id statusTextField;
#else
    NSWindow*      window;
    NSForm*        destinationForm;
    NSFormCell*    classCell;
    NSFormCell*    instanceCell;
    NSFormCell*    recipientCell;
    NSMatrix*      sendToMatrix;
    NSButton*      urgentButton;
    NSButton*      authenticateButton;
    NSPopUpButton* favoritesPopUp;
    NSPopUpButton* recentPopUp;
    NSPopUpButton* replyPopUp;
    NSButton*      findButton;
    NSButton*      sendButton;
    NSTextView*    messageTextView;
    NSTextField*   statusTextField;
#endif
}

/********************
 * Instance Methods *
 ********************/

////
// Inits
////

- (id) init;
- (id) initWithMessage: (ZephyrMessage*) aMessage;

////
// Accessors
////

- (NSString*) zephyrClass;
- (NSString*) zephyrInstance;
- (NSString*) recipient;

- (void) setZephyrClass    : (NSString*) aClass;
- (void) setZephyrInstance : (NSString*) anInstance;
- (void) setRecipient      : (NSString*) aRecipient;
- (void) setFavorites      : (NSArray* ) aList;
- (void) setRecents        : (NSArray* ) aList;
- (void) setReplies        : (NSArray* ) aList;
- (void) setStatus         : (NSString*) aMessage;

////
// IB Targets
////

#ifdef _IB_
- (void) editDestinationTarget : (id) sender;
- (void) selectSendToTarget    : (id) sender;
- (void) checkUrgentTarget     : (id) sender;
- (void) selectFromPopUpTarget : (id) sender;
- (void) locateUsersTarget     : (id) sender;
- (void) sendMessageTarget     : (id) sender;
#endif

@end
