/*
    File:       FileInfo.h

    Contains:   Interface for FileInfo, an object that gathers directory
                information from the user's filesystem

    Written by: Andy Wildenberg

    Created:    9 July 1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History:
       version 1.0: first public version

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DTS Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

@interface FileInfo : NSObject
{
    NSString* filename;
    NSString* filetype;
    NSString* lastModified;
    NSString* fullPathName; // name of the directory that holds me -- may be '.'
    NSArray* containedFiles; // a list of the files in me (if I'm a directory)
}

- (id)initWithPath:(NSString *) path;

- (NSString *)filename;
- (NSString *)fullPathName;
- (NSString *)filetype;
- (NSString *)lastModified;
- (NSArray *)containedFiles;

- (void)findContainedFiles;
- (void)setContainedFiles:(NSArray *)value;

- (void)dealloc;

- (NSComparisonResult)compare:(FileInfo *)obj;

@end
