#import <AppKit/AppKit.h>

@interface DASubController : NSObject
{
    id window;
}

+ allocDocumentZone:(NSString *)name;

+ (id)shared;
+ (id)new;

- (id)init;
- (void)awakeFromNib;

- (void)display;
- (void)display:sender;

- window;

@end

#ifndef _DA_EXCEPTION_
#define _DA_EXCEPTION_
    #define DURING	{ NS_DURING

    #define HANDLER	NS_HANDLER switch ([[[localException userInfo] objectForKey:@"Return Value"] intValue]) {

    #define IGNORE(E)	case E: NSLog( @"Ignoring exception:%@(%s) in %s:%s.\n", [localException name], #E, __FILE__, sel_getName(_cmd)); break;

    #define RERAISE	[localException raise];

    #define ENDHANDLER	default: NSLog( @"Uncaught exception: %@(%@) in %s:%s.\n[%@]\n",  [localException name], [[localException userInfo] objectForKey:@"Return Value"],  __FILE__, sel_getName(_cmd), [localException reason]); abort();} NS_ENDHANDLER }

    #define FUNCT_ENDHANDLER	default: NSLog( @"Uncaught exception: %@(%@) in %s.\n[%@]\n", [localException name], [[localException userInfo] objectForKey:@"Return Value"], __FILE__, [localException reason]); abort(); } NS_ENDHANDLER }

#endif
