/* DAPreferences.m created by aspinall on Sun 11-Jan-1998 */

#import "DAPreferences.h"
#import "FilteredFileInfo.h"

@implementation DAPreferences

static	DAPreferences	*_shared_pref = nil;

+ (id)shared
{
    if ( _shared_pref == nil )
        _shared_pref = [[DAPreferences alloc] init];

    return _shared_pref;
}

- init
{
    self = [super init];
    if ( self )
    {
        imageFilterTypes = [[[NSUserDefaults standardUserDefaults] dictionaryForKey:FilterForExtensionsDefault] mutableCopy];
    }
    return self;
}

- (void)display
{
    [tableView reloadData];
    [super display];
}

- (void)addImageType:(id)sender
{
    [imageFilterTypes setObject:@"New image file extension" forKey:@"ext"];
    [[NSUserDefaults standardUserDefaults] setObject:imageFilterTypes forKey:FilterForExtensionsDefault];
    [tableView reloadData];
}
- (void)deleteImageType:(id)sender
{
    NSArray *types = [imageFilterTypes allKeys];
    int	row = [tableView selectedRow];

    if ( row < [types count] )
    {
        NSString *key = [types objectAtIndex:row];
        [imageFilterTypes removeObjectForKey:key];
        [[NSUserDefaults standardUserDefaults] setObject:imageFilterTypes forKey:FilterForExtensionsDefault];
        [tableView reloadData];
    }
}

- (int)numberOfRowsInTableView:(NSTableView *)tableView;
{
    return [[imageFilterTypes allKeys] count];
}
- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row;
{
    NSString	*retVal = nil;
    NSArray	*keys = [[imageFilterTypes allKeys] sortedArrayUsingSelector:@selector(compare:)];
    
    if ( row < [keys count] )
    {
        retVal = [keys objectAtIndex:row];
        if ( [(NSString *)[tableColumn identifier] compare:@"description"] == NSOrderedSame )
        {
            retVal = [imageFilterTypes objectForKey:retVal];
        }
    }

    return retVal;
}
- (void)tableView:(NSTableView *)tableView setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn row:(int)row;
{
    NSArray	*keys = [[imageFilterTypes allKeys] sortedArrayUsingSelector:@selector(compare:)];
    
    if ( row < [keys count] )
    {
        NSString *aKey = [keys objectAtIndex:row];
        if ( [(NSString *)[tableColumn identifier] compare:@"description"] == NSOrderedSame )
        {
            if ( [(NSString *)[imageFilterTypes objectForKey:aKey] compare:object] != NSOrderedSame )
            {
               [imageFilterTypes setObject:object forKey:aKey];
            }
        }
        else
        {
            if ( [aKey compare:object] != NSOrderedSame )
            {
                [imageFilterTypes setObject:[imageFilterTypes objectForKey:aKey] forKey:object];
                [imageFilterTypes removeObjectForKey:aKey];
            }
        }
    }
    [[NSUserDefaults standardUserDefaults] setObject:imageFilterTypes forKey:FilterForExtensionsDefault];
}

@end
