#import <AppKit/AppKit.h>
#import "FilteredFileInfo.h"
#import "DASubController.h"

@interface DAImageBrowser : DASubController
{
    id imageView;
    id outlineView;
    id descText;

    NSString	*root;
    FilteredFileInfo	*topFileInfo;
}

+ (DAImageBrowser *)openNewDirectory;

- (void)setRoot:(NSString *)value;
- (NSString *)root;

- (void)delete:sender;
- (void)displayImage:sender;

// routines for the outline view
- (id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item;
- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable: (id)item;
- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item;
- (id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item;

@end
