#import <AppKit/AppKit.h>
#import "StockDataSource.h"

@class MLMarqueeView;

@interface WindowController : NSObject
{
    @private
    IBOutlet NSTextView *textView;
    IBOutlet MLMarqueeView *marqueeView;
    IBOutlet NSScrollView *testScrollView;
    StockDataSource *dataSource;
    unsigned maxOffset;

    float symbolUpdateInterval;

    IBOutlet NSWindow *window;
}

- (void) reloadSymbols;
- (StockDataSource *) dataSource;

- (MLMarqueeView *) marqueeView;
- (NSWindow *) window;

- (void) killWindow;

+ (NSFont *) baseFont;
@end
