/* StockDataSource.h created by mlaster on Thu 15-Jul-1999 */

#import <AppKit/AppKit.h>
#define StockDataUpdatedNotification @"StockDataUpdatedNotification"
/*
 Stock dictionary keys
 Symbol -- Stock symbol
 Price	-- Price (NSNumber)
 Volume -- Volume (NSNumber)
 LastUpdated -- Time this stock's price was last updated (NSDate)
 Open	-- Opening price (NSNumber)
 */
@interface StockDataSource : NSObject
{
    @private
    NSMutableDictionary *statDictionary;
    NSDictionary *colorCodes;

    float positiveThreshold;
    float negativeThreshold;

    BOOL showVolume;
    BOOL showPercentageChange;
    BOOL displayInMenuBar;
    BOOL useFractionalRepresentation;
    NSNumberFormatter *indexNumberFormatter;
    NSNumberFormatter *stockNumberFormatter; // only used for decimal notation

    NSFont *baseFont;
}

+ (StockDataSource *) dataSource;

+ (void) loadDataSourceBundles;
+ (void) registerDataSource:(NSString *)className;

// call [super update] only when you have new data available
- (void) update;

- (void) addSymbol:(NSMutableDictionary *)aSymbol;
- (void) removeSymbol:(NSString *)aSymbol;
- (void) removeAllSymbols;

- (NSMutableDictionary *) statDictionary;
- (void) setStatDictionary:(NSMutableDictionary *)newDictionary;

- (NSAttributedString *) attributedString;
- (NSAttributedString *) attributedStringForStockDictionary:(NSDictionary *)aDictionary;

- (void) reloadSymbols;

- (void) setPositiveThreshold: (float) aNum;
- (void) setNegativeThreshold: (float) aNum;
@end
