/* PreferencesController.h created by mlaster on Sat 17-Jul-1999 */

#import <AppKit/AppKit.h>

#define SymbolListUpdatedNotification @"SymbolListUpdatedNotification"

@interface PreferencesController : NSObject
{	
    @private
    // proxy controls
    IBOutlet NSPanel *prefPanel;
    IBOutlet NSButton *proxyCheckbox;
    IBOutlet NSForm *proxyForm;

    // stock controls
    IBOutlet NSButton *addButton;
    IBOutlet NSButton *removeButton;
    IBOutlet NSTextField *stockEntryField;
    IBOutlet NSBrowser *stockBrowser;

    // data source
    IBOutlet NSPopUpButton *dataSourcePopUp;

    IBOutlet NSButton *applyButton;

    // useful state
    NSMutableDictionary *symbolList;
    NSString *proxyServer;
    BOOL shouldUseProxy;
}

// actions
- (IBAction) addStock:(id)sender;
- (IBAction) removeStocks:(id)sender;
- (IBAction) apply:(id)sender;
- (IBAction) toggleProxy:(NSButton *)sender;
- (IBAction) proxyChanged:(NSTextField *)sender;
- (void) showPanel;
- (void) syncWithDefaults;

@end
