/* MLHTTPConnection.m created by mlaster on Fri 16-Jul-1999 */

#import "MLHTTPConnection.h"
#import "MLHTTPRequest.h"

@implementation MLHTTPConnection

+ (void) setupPosing
{
    [self poseAsClass:[NSHTTPConnection class]];
}

// override this
- (NSHTTPConnection *) initWithHost:(NSHost *)aHost port:(unsigned int)aPort
{
    id retValue = nil;
    BOOL shouldUseProxy = NO;
    NSString *proxyString = nil;
    NSURL *proxyURL = nil;

    shouldUseProxy = [[NSUserDefaults standardUserDefaults] boolForKey:@"ShouldUseProxy"];
    if (shouldUseProxy == YES)
    {
        proxyString = [[NSUserDefaults standardUserDefaults] stringForKey:@"ProxyURL"];
        proxyURL = [NSURL URLWithString:proxyString];
        retValue = [super initWithHost:[NSHost hostWithName:[proxyURL host]]
                                  port:[[proxyURL port] unsignedIntValue]];
    }
    else
    {
        retValue = [super initWithHost:aHost port:aPort];
    }
    return retValue;
}

@end
