/* MenuView.m created by bbum on Sat 21-Aug-1999 */

#import "MenuView.h"
#import "NSUserDefaults+ColorExtensions.h"

@implementation MenuView
- (id)initWithFrame:(NSRect)frameRect;
{
    [super initWithFrame: frameRect];

    backgroundColor = [[NSUserDefaults standardUserDefaults] colorForKey: @"TickerMenuBackgroundColor"];

    [self setAutoresizesSubviews: NO];
    [self setPostsFrameChangedNotifications: YES];

    [[NSNotificationCenter defaultCenter] addObserver: self selector: @selector(frameChangedNotif:) name: NSViewFrameDidChangeNotification object: self];
    
    return self;
}

- (void) frameChangedNotif: aNotif
{
    NSRect b;
    NSRect cB;

    b = [self bounds];

    cB = NSMakeRect(0, 2, b.size.width, b.size.height - 3);

    [contentView setFrame: cB];
}

- (void) setContentView: (NSView *) aView;
{
    if (contentView != nil) {
        [contentView removeFromSuperview];
        [contentView release];
    }
    contentView = [aView retain];

    [self frameChangedNotif: nil]; // fake a frame changed

    [self addSubview: contentView];
}

- (void)drawRect:(NSRect)rect;
{
    [backgroundColor set];
    NSRectFill(rect);

    if (rect.origin.y <= 1) {
        NSRect b = [self bounds];

        NSDrawButton(NSMakeRect(-5, 0, b.size.width + 10, b.size.height), NSMakeRect(rect.origin.x, rect.origin.y, rect.size.width, b.size.height));
    }
}


@end
