/* YahooDataSource.m created by mlaster on Fri 16-Jul-1999 */

#import "YahooDataSource.h"
@implementation YahooDataSource

+ (void)load
{
    [StockDataSource registerDataSource:[self description]];
}

- (void) update
{
    NSMutableString *fetchURL = nil;
    NSArray *keys=nil;
    NSURL *url = nil;

    keys = [[self statDictionary] allKeys];
    if ([keys count] > 0)
    {
        fetchURL = [NSString stringWithFormat:@"http://finance.yahoo.com/d/quotes.csv?s=%@&f=sl1d1t1c1ohgv&e=.csv",
            [keys componentsJoinedByString:@"+"]];
        url = [NSURL URLWithString:fetchURL];

        [url loadResourceDataNotifyingClient:self usingCache:NO];
    }
}

// NSURL delegate methods
- (void)URL:(NSURL *)sender resourceDataDidBecomeAvailable:(NSData *)newBytes
{
//    NSLog(@"TRACE: URL:[%@] resourceDataDidBecomeAvailable:[%@]", sender, newBytes);
}

- (void)URLResourceDidFinishLoading:(NSURL *)sender
{
    NSString *returnString = nil;
    unsigned int i=0;
    NSString *symbol=nil;
    NSNumber *workNumber=nil;
    NSMutableDictionary *statDict = nil;
    NSMutableDictionary *stock = nil;
    NSMutableArray *returnArray = nil;
    NSArray *individual = nil;

//    NSLog(@"TRACE: URLResourceDidFinishLoading:[%@]", sender);
    statDict = [self statDictionary];
    returnString = [[[NSString alloc] initWithData:[sender resourceDataUsingCache:YES]
                                          encoding:[NSString defaultCStringEncoding]] autorelease];
    returnArray = [[returnString componentsSeparatedByString:@"\r\n"] mutableCopy];
    [returnArray removeLastObject];
    for (i=0;i<[returnArray count];i++)
    {
        individual = [[returnArray objectAtIndex:i] componentsSeparatedByString:@","];

        // extract symbol (element 0)
        symbol = [individual objectAtIndex:0];
        symbol = [symbol substringWithRange:NSMakeRange(1,[symbol length]-2)];


        stock = [statDict objectForKey:symbol];

        // extract price (element 1)
        workNumber = [NSNumber numberWithFloat:[[individual objectAtIndex:1] floatValue]];
        [stock setObject:workNumber forKey:@"Price"];

        // extract change (element 4)
        workNumber = [NSNumber numberWithFloat:[[individual objectAtIndex:4] floatValue]];
        [stock setObject:workNumber forKey:@"Change"];
        
        // extract volume (element 8)
        workNumber = [NSNumber numberWithInt:[[individual objectAtIndex:8] intValue]];
        [stock setObject:workNumber forKey:@"Volume"];
    }
    [super update];

}

- (void)URLResourceDidCancelLoading:(NSURL *)sender
{
    NSLog(@"TRACE: URLResourceDidCancelLoading:[%@]", sender);
}

- (void)URL:(NSURL *)sender resourceDidFailLoadingWithReason:(NSString *)reason
{
    NSLog(@"TRACE: URL:[%@] resourceDidFailLoadingWithReason:[%@]", sender, reason);
}

- (NSData *)hyperlinkForSymbol:(NSString *)aSymbol
{
    return [[NSString stringWithFormat:
                      @"<a href=\"http://finance.yahoo.com/q?d=t&s=%@\">%@</a> ", aSymbol, aSymbol] dataUsingEncoding: NSWindowsCP1252StringEncoding];
}

@end
