#import "AppController.h"
#import "WindowController.h"
#import "PreferencesController.h"
#import "StockDataSource.h"
#import "MLHTTPConnection.h"
#import "MLMarqueeView.h"
#import "MLHTTPRequest.h"
#import "MenuView.h"
#import "NSUserDefaults+ColorExtensions.h"

#import "FilesOwnerFakeOut.h"

@implementation AppController

// actions
- (IBAction) aboutPanel:(id)sender
{
    [NSApp orderFrontStandardAboutPanel:sender];
}

- (IBAction) showPreferencesPanel:(id)sender
{
    if (prefController == nil)
    {
        if ([NSBundle loadNibNamed:@"Preferences" owner:self] == NO)
        {
            [NSException raise:NSGenericException format:@"Unable to load Preferences.nib"];
        }
    }
    [prefController showPanel];
}

- (IBAction) showReadme:(id)sender
{
    NSString *readmePath = nil;
    BOOL success = NO;
    
    readmePath = [[NSBundle mainBundle] pathForResource:@"README" ofType:@"rtf"];

    if (readmePath != nil)
    {
        
        NSLog(@"TRACE: show %@", readmePath);
        success = [[NSWorkspace sharedWorkspace] openFile:readmePath withApplication:nil andDeactivate:YES];
            NSLog(@"success=[%d]", success);
    }
}

- (void) reloadSymbols:(NSNotification *)aNotification
{
    if ([[NSUserDefaults standardUserDefaults] boolForKey: @"DisplayInMenuBar"] == NO)
        [winController reloadSymbols];
    else
        [menuBarWindowController reloadSymbols];
}
- (void) applicationWillFinishLaunching:(NSNotification *)aNotification
{
    [[NSUserDefaults standardUserDefaults] registerDefaults: [[[NSBundle mainBundle] infoDictionary] objectForKey: @"RegistrationDefaults"]];

    // enable proxy support
    [MLHTTPConnection setupPosing];
    [MLHTTPRequest setupPosing];
    
    [StockDataSource loadDataSourceBundles];
}

- (void) insertMenuBarAccountrement
{
    int length;
    float height;
    NSRect marqueeBounds;
    
    if (systemStatusBar == nil)
        systemStatusBar = [[NSStatusBar systemStatusBar] retain];

    length = [[NSUserDefaults standardUserDefaults] integerForKey: @"MenuBarItemLength"];

    stockTickerItem = [[systemStatusBar statusItemWithLength: length] retain];  // we MUST retain this-- regardless of whether or not it is ever used again... status bar doesn't!

    if (menuBarWindowController == nil) {
        FilesOwnerFakeOut *filesOwnerFakeOut = [[FilesOwnerFakeOut alloc] init];

        if ([NSBundle loadNibNamed: @"MainWindow" owner: filesOwnerFakeOut] == NO)
            [NSException raise:NSGenericException format:@"Unable to load MainWindow.nib"];

        menuBarWindowController = [[filesOwnerFakeOut winController] retain];
        [filesOwnerFakeOut release];

        menuBarMarqueeView = [[menuBarWindowController marqueeView] retain];

        [menuBarWindowController killWindow];

        height = [systemStatusBar thickness];

        marqueeBounds = NSMakeRect(0, -2, length, height - 2);
        menuView = [[MenuView alloc] initWithFrame: marqueeBounds];

        [menuView setContentView: menuBarMarqueeView];
//        [menuBarMarqueeView setFrame: marqueeBounds];

        [stockTickerItem setView: menuView];
    }
}

- (void) removeMenuBarAccoutrement
{
    ;
}

- (void) reconfigureDisplay: (NSNotification *) aNotification // only declared as this so it could be target of defaults change notif?
{
    if ([[NSUserDefaults standardUserDefaults] boolForKey: @"DisplayInMenuBar"] == NO) {
        if (winController == nil) {
            if ([NSBundle loadNibNamed:@"MainWindow" owner:self] == NO)
                [NSException raise:NSGenericException format:@"Unable to load MainWindow.nib"];
        }

        [self removeMenuBarAccoutrement];
        [[winController window] makeKeyAndOrderFront: self];
    } else
        [self insertMenuBarAccountrement];
}

- (void) applicationDidFinishLaunching:(NSNotification *)aNotification
{
    [self reconfigureDisplay: aNotification];

    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(reloadSymbols:)
                                                 name:SymbolListUpdatedNotification
                                               object:nil];
    // load symbol list
    [self reloadSymbols:nil];
}

@end
