#import "SmallImageView.h"

@implementation SmallImageView

- initWithFrame:(NSRect)rect
{
    NSColor *greenColor=[NSColor greenColor];
    NSColor *blackColor=[[NSColor blackColor] colorWithAlphaComponent:0.0];

    if (!(self = [super initWithFrame:rect]))
        return nil;

    operator = NSCompositeSourceOver;

    wakuImage=[NSImage allocWithZone:[self zone]];
    [wakuImage initWithSize:NSMakeSize(320,240)];
    clearImage=[NSImage allocWithZone:[self zone]];
    [clearImage initWithSize:NSMakeSize(320,240)];

    [wakuImage lockFocus];
    PSnewpath();
    PSmoveto(0,0);
    PSlineto(0,239);
    PSlineto(319,239);
    PSlineto(319,0);
    PSclosepath();
    [greenColor set];
    PSfill();
    PSnewpath();
    PSmoveto(1,1);
    PSlineto(1,238);
    PSlineto(318,238);
    PSlineto(318,1);
    PSclosepath();
    [blackColor set];
    PSfill();
    [wakuImage unlockFocus];

    [clearImage lockFocus];
    PSnewpath();
    PSmoveto(0,0);
    PSlineto(0,239);
    PSlineto(319,239);
    PSlineto(319,0);
    PSclosepath();
    [blackColor set];
    PSfill();
    [clearImage unlockFocus];



    [self registerForDraggedTypes:
        [NSArray arrayWithObjects:NSFilenamesPboardType, nil]];

    return self;
}

- (void)drawRect:(NSRect)rect
{
    NSPoint newPoint=rect.origin;
    [self lockFocus];
    [imageSource compositeToPoint:newPoint
                 operation:operator];
    [self unlockFocus];
}

- (NSString *)currentFilename
{
    return currentFilename;
}


- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender
{
    //NSLog(@"entered");

    return [self draggingUpdated:sender];
}

- (unsigned int)draggingUpdated:(id <NSDraggingInfo>)sender
{

    NSPasteboard *pboard = [sender draggingPasteboard];
    unsigned int sourceDragMask = [sender draggingSourceOperationMask];

    if ([[pboard types] indexOfObject:NSStringPboardType]) {
        if (sourceDragMask & NSDragOperationGeneric) {

            imageSource=[wakuImage retain];
            [self display];
            return NSDragOperationGeneric;
        }
    }

    //NSLog(@"NSDragOperationNone");
    return NSDragOperationNone;
}

- (void)draggingExited:(id <NSDraggingInfo>)sender
{
    //NSLog(@"Exited");
    imageSource=[clearImage retain];
    [self display];
}

- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender
{
    if ([self draggingUpdated:sender] == NSDragOperationNone)
        return NO;
    return YES;
}

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender
{
    if ([self draggingUpdated:sender] == NSDragOperationNone)
        return NO;
    return YES;
}

- (void)concludeDragOperation:(id <NSDraggingInfo>)sender
{
    NSArray * filenameArray;
    int nameCount;

    NSPasteboard *pboard = [sender draggingPasteboard];

    filenameArray = [pboard propertyListForType:NSFilenamesPboardType];
    nameCount = [filenameArray count];

    if (nameCount == 1) {
        currentFilename=[[filenameArray objectAtIndex:0] copy];
        [self displaySmallImage:currentFilename];

        [addButton setEnabled:YES];


        //NSLog(@"selectedColumn=%d",[[myScrollView documentView] selectedColumn]);

        if ([[myScrollView documentView] selectedRow] != -1) {
            [insertButton setEnabled:YES];
            [replaceButton setEnabled:YES];
        }

    } else {
        //ʣΥե뤬ɥå줿(̤)
        //for (i=0;i<nameCount;i++) {
        //}
    }

}

- (void)displaySmallImage:(NSString *)filename
{
    myImageRep=[NSImageRep imageRepWithContentsOfFile:[filename stringByExpandingTildeInPath]];
    [myImageRep setAlpha:NO];
    imageSource=[[NSImage allocWithZone:[self zone]] initWithSize:NSMakeSize(320,240)];
    [imageSource setScalesWhenResized:YES];
    [imageSource addRepresentation:myImageRep];

    [self display];

}

@end
