/* SlideView.m created by nakamura on Sat 26-Sep-1998 */

#import "SlideView.h"

@implementation SlideView
- initWithFrame:(NSRect)rect
{

    if (!(self = [super initWithFrame:rect]))
        return nil;

    myRect=rect;

    return self;

}


- (BOOL)acceptsFirstResponder
{
    return YES;
}
- (BOOL)becomeFirstResponder
{
    return YES;
}
- (BOOL)resignFirstResponder
{
    return YES;
}


- (void)keyDown:(NSEvent *)theEvent
{
    unsigned char keyChar;
    NSString *keyString = [theEvent characters];
    keyChar=[keyString characterAtIndex:0];

    //NSLog(@"char is %d",keyChar);

    switch(keyChar) {

        case 2 :[self showPrevPicture]; break;          //<-
        case 3 :[self showNextPicture]; break;          //->
        case 32 :[self showNextPicture]; break;         //SPACE
        case 27:[[NSApp keyWindow] release]; break;     //ESC
        case 113:[[NSApp keyWindow] release]; break;    //q

    }

}

- (void)mouseDown:(NSEvent *)theEvent
{
    //shift keyȶ˥åƤ顢Υ饤ɤ롣
    //åʤ顢Υ饤ɤɽ롣

    if ([theEvent modifierFlags]&&NSShiftKeyMask) {
        [self showPrevPicture];
    } else {
        [self showNextPicture];
    }
}

- (void)rightMouseDown:(NSEvent *)theEvent
{
    //[self showNextPicture];
    [self showPrevPicture];
}


- (void)showNextPicture
{
    if (currentPicture < maxPictures ) {
        currentPicture++;
        [self showPicture:currentPicture];
    }
}

- (void)showPrevPicture
{
    if (currentPicture > 0 ) {
        currentPicture--;
        [self showPicture:currentPicture];
    }
}

- (void)showPicture:(unsigned int)num
{
    myImageRep=[NSImageRep imageRepWithContentsOfFile:[myDocumentPath stringByAppendingPathComponent:[pictures objectAtIndex:num]]];
    [myImageRep setAlpha:NO];
  	//myImage=[[NSImage allocWithZone:[self zone]]
	//               initWithSize:NSMakeSize(myRect.size.width,myRect.size.width*3/4)];
    myImage=[[NSImage allocWithZone:[self zone]]
                       initWithSize:NSMakeSize(myRect.size.width,myRect.size.height)];

    [myImage setScalesWhenResized:YES];
    [myImage addRepresentation:myImageRep];

    [self display];


}

- (void)setPictureList:(NSMutableArray *)pictureList
{

    pictures=[pictureList retain];

    maxPictures=[pictureList count]-1;
    currentPicture=0;

    [self showPicture:currentPicture];

}

- (void)setDocumentPath:(NSString *)path
{

    myDocumentPath=[path retain];

}


- (void)drawRect:(NSRect)rect
{
    //NSSize size = rect.size;
    NSPoint newPoint=rect.origin;
    [self lockFocus];
    [myImage compositeToPoint:newPoint
                    operation:NSCompositeSourceOver];
    [self unlockFocus];


}

@end
