#import <AppKit/AppKit.h>
#import "ThumbnailCell.h"
#import "SlideView.h"
#import "SlideWindow.h"

typedef struct _CellPoint {
    unsigned int x;
    unsigned int y;
} CellPoint;

@interface Document : NSObject
{
    id addButton;
    id deleteButton;
    id docWindow;
    id insertButton;
    id newWindow;
    id replaceButton;
    id slideScroll;
    id smallImageView;
    id runButton;

    NSMutableArray *pictureList;
    NSString *pictureListFile;
    NSString *documentPath;

    NSMatrix *thumbnailMatrix;

    unsigned int selectedPict;
    unsigned int maxRow;
    //unsigned int numberOfPics; //̿


    int remainCells;


    SlideView *aSlideView;

}
- (id)initWithDocument:(NSString *)aPath;
- (void)refreshThumbnailView;
- (void)setInfoToCellWithImage;
- (void)makeFront;
- (void)checkRemainCellsAtRow:(int)aRow;
- (void)addNewData:(id)sender;
- (void)deleteData:(id)sender;
- (void)insertData:(id)sender;
- (void)replaceData:(id)sender;
- (void)runSlide:(id)sender;
- (void)clickAct:(id)sender;
- (void)doubleClickAct:(id)sender;
- (BOOL)saveDocument;
- (void)revertToSaved;
- (void)restoreFile;
- (void)saveAs:(NSString *)aPath;

@end
