#import "AppControl.h"

@implementation AppControl

- (id)init
{
    currentDir=NSHomeDirectory();

    return self;
}


- (void)newDoc:(id)sender
{
    NSFileManager *fileManager;
    NSNumber *permission;
    NSDictionary *anAttribute;
    NSString *documentPath;
    BOOL isDir=NO;


    int result;
    NSSavePanel *sPanel = [NSSavePanel savePanel];

    [sPanel setTitle:NSLocalizedString(@"New Document File",@"")];
    [sPanel setRequiredFileType:@"lpf"];

    result = [sPanel runModalForDirectory:currentDir file:nil];

    if (result == NSOKButton) {
        documentPath=[[sPanel filename] copy];
        currentDir=[[documentPath stringByDeletingLastPathComponent] copy];
        //current dir ¸
    } else {
        return;
    }


    fileManager=[NSFileManager defaultManager];

    if ([fileManager fileExistsAtPath:documentPath isDirectory:&isDir] && isDir) {
        [fileManager removeFileAtPath:documentPath handler:nil];
        //⤷documentPath¸ߤƤϺ롣
    }

    permission = [[NSNumber alloc] initWithInt:493];
    anAttribute=[NSDictionary dictionaryWithObject:permission forKey:NSFilePosixPermissions];
    [fileManager createDirectoryAtPath:documentPath attributes:anAttribute];

    [[Document alloc] initWithDocument:documentPath];

}

- (void)saveDoc:(id)sender
{
    id currentDoc=[[NSApp mainWindow] delegate];
    [currentDoc saveDocument];
}

- (void)saveAs:(id)sender
{
    NSFileManager *fileManager;
    NSNumber *permission;
    NSDictionary *anAttribute;
    NSString *documentPath;
    BOOL isDir=NO;

    id currentDoc=[[NSApp mainWindow] delegate];

    int result;
    NSSavePanel *sPanel = [NSSavePanel savePanel];

    [sPanel setTitle:NSLocalizedString(@"Save As",@"")];
    [sPanel setRequiredFileType:@"lpf"];

    result = [sPanel runModalForDirectory:currentDir file:nil];

    if (result == NSOKButton) {
        documentPath=[[sPanel filename] copy];
        currentDir=[[documentPath stringByDeletingLastPathComponent] copy];
        //current dir ¸
    } else {
        return;
    }

    fileManager=[NSFileManager defaultManager];

    if ([fileManager fileExistsAtPath:documentPath isDirectory:&isDir] && isDir) {
        [fileManager removeFileAtPath:documentPath handler:nil];
        //⤷documentPath¸ߤƤϺ롣
    }



    permission = [[NSNumber alloc] initWithInt:493];
    anAttribute=[NSDictionary dictionaryWithObject:permission forKey:NSFilePosixPermissions];
    [fileManager createDirectoryAtPath:documentPath attributes:anAttribute];

    [currentDoc saveAs:documentPath];

}

- (void)showInfoPanel:(id)sender
{
    if (!infoPanel) {
            infoPanel=[[InfoPanel alloc] init];
    }

    [infoPanel showInfoPanel];
}

- (void)openDoc:(id)sender
{
    int result;
    //NSString *startDir;
    NSArray *fileTypes=[NSArray arrayWithObject:@"lpf"];
    NSOpenPanel *oPanel = [NSOpenPanel openPanel];

    [oPanel setAllowsMultipleSelection:YES];
    [oPanel setCanChooseFiles:YES];	
    //startDir=NSHomeDirectory();

    result = [oPanel runModalForDirectory:currentDir file:nil types:fileTypes];
    if (result == NSOKButton) {
        NSArray *filesToOpen = [oPanel filenames];
        int count = [filesToOpen count];


                    while(count--) {
                        NSString *aPath = [filesToOpen objectAtIndex:count];
                        currentDir=[[aPath stringByDeletingLastPathComponent] copy];
                        [[Document alloc] initWithDocument:aPath];
                    }
    }


}

- (void)revertToSaved:(id)sender
{
    id currentDoc=[[NSApp mainWindow] delegate];
    [currentDoc revertToSaved];
}


- (void)showHelp:(id)sender
{
    if (!help) {
        help= [[Document alloc] initWithDocument:[[NSBundle mainBundle] pathForResource:@"manual" ofType:@"lpf"]];
    }

    [help makeFront];

}


- (BOOL)application:(id)sender openFile:(NSString *)filename
{
    id currentDoc=[[Document alloc] initWithDocument:filename];
        if (currentDoc) {
            return YES;
        } else {
            return NO;
        }
}

- (BOOL)applicationShouldTerminate:(NSApplication *)app
{
        int result;

    //NSLog(@"terminate");

        while ([NSApp mainWindow]) {

                id doc = [[NSApp mainWindow] delegate];

                if ([[NSApp mainWindow] isDocumentEdited] == NO) {
                    [[NSApp mainWindow] close];
                    [doc release];
                } else {
                    result = NSRunAlertPanel(NSLocalizedString(@"Close",@""),
                                             NSLocalizedString(@"Edited",@""),
                                             NSLocalizedString(@"Save",@""),
                                             NSLocalizedString(@"Don't Save",@""),
                                             NSLocalizedString(@"Cancel",@""));

                        switch(result) {
                        case NSAlertDefaultReturn: {
                            //NSLog(@"save");
                            if([doc saveDocument]==YES) {
                                [[NSApp mainWindow] close];
                                [doc release];
                            } else {
                                return NO;
                            }
                            break;
                        }
                        case NSAlertAlternateReturn: {
                            //NSLog(@"do not save");
                            [doc revertToSaved];
                            [[NSApp mainWindow] close];
                            [doc release];
                            break;
                        }
                        case NSAlertOtherReturn: {
                            //NSLog(@"cancel");
                            return NO;
                            break;
                        }
                        }
                }

        continue;
    }

        return YES;
}



@end
