/*
 Project:	UPlipo
 File:      LipoManager.m
 Creator:	Philippe C.D. Robert
 Created:   February 21, 1998

 Copyright: (c) 1998 by Philippe C.D. Robert, all rights reserved.

 GPL applies whithout any restrictions!
 */

/*
 ToDo:

 Ugly implementation...<g>

 */

#import "LipoManager.h"

@implementation LipoManager

#define PATH_TO_LIPO @"/usr/bin/lipo"

// ===========================================================================
// ==== lipo methods
// ===========================================================================

- (void)infoAboutExecutable:(NSString *)pathString args:(NSString *)args
{
    NSTask 			*lipoTask;    			// lipo
    NSPipe 			*myPipe;
    NSArray 		*arguments = nil;  		// args for lipo
    NSString 		*inputFile = @"";     	// source AND destination for lipo!
    BOOL 			isDir = NO;				// is a directory
    NSFileHandle	*readHandle;
    NSData 			*inData = nil;
    NSString 		*outputString = @"";

    fileManager = [NSFileManager defaultManager];
    dirEnumerator = [fileManager enumeratorAtPath:pathString];

    lipoTask = [[NSTask alloc] init];
    myPipe = [NSPipe pipe];             	// pipe delivers an autoreleased NSPipe!
    readHandle = [myPipe fileHandleForReading];
    [lipoTask setStandardOutput:myPipe];
    [lipoTask setStandardError:myPipe];
    [lipoTask setLaunchPath:PATH_TO_LIPO];

    while (inputFile = [dirEnumerator nextObject])
      {
        inputFile = [NSString stringWithFormat:@"%@/%@",pathString,inputFile];
        
        if ([fileManager isExecutableFileAtPath:inputFile] && [fileManager fileExistsAtPath:inputFile isDirectory:&isDir] && !isDir)
          {
            arguments = [NSArray arrayWithObjects:args,inputFile,nil];
            [lipoTask setArguments:arguments];
            [lipoTask launch];
            
            while ((inData = [readHandle availableData]) && [inData length])
              {
                outputString = [[NSString alloc] initWithData:inData encoding:NSASCIIStringEncoding];
                if (delegate && [delegate respondsToSelector:@selector(lipoManager:didLog:)])
                  {
                    [delegate lipoManager:self didLog:outputString];
                  }
                [outputString release];
              }
            [lipoTask waitUntilExit];
          }
      }
    [lipoTask release];
}

- (void)thinTargetExecutableAtPath:(NSString *)aPath targetArchitecture:(int)arch
{
    NSTask 			*lipoTask;            	// lipo
    NSPipe 			*myPipe;
    NSArray 		*arguments = nil;   	// args for lipo
    NSString 		*inputFile=@"";       	// source AND destination for lipo!
    BOOL 			isDir = NO;				// is a directory
    NSString 		*archString = @"";
    NSFileHandle 	*readHandle;
    NSData 			*inData = nil;
    NSString 		*outputString = @"";

    dirEnumerator = [fileManager enumeratorAtPath:aPath];

    lipoTask = [[NSTask alloc] init];
    myPipe = [NSPipe pipe];             	// pipe delivers an autoreleased NSPipe!
    readHandle = [myPipe fileHandleForReading];
    [lipoTask setStandardOutput:myPipe];
    [lipoTask setStandardError:myPipe];

    // which architecture?
    switch(arch)
      {
        case 0:
            archString = @"ppc";
            break;
        case 1:
            archString = @"i386";
            break;
        case 2:
            archString = @"i486";
      }

    [lipoTask setLaunchPath:PATH_TO_LIPO];

    while (inputFile = [dirEnumerator nextObject])
      {
        inputFile = [NSString stringWithFormat:@"%@/%@",aPath,inputFile];

        if ([fileManager isExecutableFileAtPath:(NSString *)inputFile] && [fileManager fileExistsAtPath:inputFile isDirectory:&isDir] && !isDir)
          {
            arguments = [NSArray arrayWithObjects:@"-thin", archString, inputFile, @"-output", inputFile, nil];

            [lipoTask setArguments:arguments];
            [lipoTask launch];
            while ((inData = [readHandle availableData]) && [inData length])
              {
                outputString = [[NSString alloc] initWithData:inData encoding:NSASCIIStringEncoding];
                if (delegate && [delegate respondsToSelector:@selector(lipoManager:didLog:)])
                  {
                    [delegate lipoManager:self didLog:outputString];
                  }
                [outputString release];
              }
            [lipoTask waitUntilExit];
          }
      }
    [lipoTask release];
}

//===========================================================================================
//==== Delegate accessor methods
//===========================================================================================

- delegate
{
    return delegate;
}

- (void)setDelegate:(id)aDelegate
{
    delegate = aDelegate;	// NOT retained!!!
}

@end
