/*
 Project:	UPlipo
 File:      LipoManager.h
 Creator:	Philippe C.D. Robert
 Created:   February 21, 1998

 Copyright: (c) 1998 by Philippe C.D. Robert, all rights reserved.

 GPL applies whithout any restrictions!
 */

#import <AppKit/AppKit.h>

@interface LipoManager : NSObject
{
    NSFileManager 			*fileManager;
    NSDirectoryEnumerator	*dirEnumerator;  // all possible targets

    id						delegate;
}

// ===========================================================================
// ==== lipo methods
// ===========================================================================

- (void)infoAboutExecutable:(NSString *)pathString args:(NSString *)args;
- (void)thinTargetExecutableAtPath:(NSString *)aPath targetArchitecture:(int)arch;

//===========================================================================================
//==== Delegate accessor methods
//===========================================================================================

- delegate;
- (void)setDelegate:(id)aDelegate;

@end

@interface NSObject (LipoManagerDelegates)

- (void)lipoManager:(id)sender didLog:(NSString *)logString;

@end
