/*
 Project:	UPlipo
 File:      DDView.m
 Creator:	Philippe C.D. Robert
 Created:   February 21, 1998

 Copyright: (c) 1998 by Philippe C.D. Robert, all rights reserved.

 GPL applies whithout any restrictions!
*/

#import "DDView.h"

NSString *DDViewFileDropped = @"DDViewFileDroppedNotification";

@implementation DDView

// ===========================================================================
// ==== Init & free methods
// ===========================================================================

- initWithFrame:(NSRect)aFrame;
{
    if (self = [super initWithFrame:aFrame])
      {
        [self registerForDraggedTypes:[NSArray arrayWithObjects:NSFilenamesPboardType, nil]];
        thinPath = [[NSString alloc] init];
      }    
    return self;
}

- (void)dealloc
{
    [thinPath release];

    [super dealloc];
}

// ===========================================================================
// ==== Drawing methods
// ===========================================================================

- (void)drawRect:(NSRect)aRect;
{
    NSPoint	offset = { 0,0 };
    NSColor *white = [NSColor whiteColor];

    NSRectFillListWithColors( &aRect, &white, 1 );
    
    if (!icon && filename)
      {
        icon = [[[NSWorkspace sharedWorkspace] iconForFile:filename] retain];
        if (!icon)
          {
            filename=nil;
          }
      }
    if (icon)
      {
        offset.x = ([self frame].size.width - [icon size].width) / 2;
        offset.y = ([self frame].size.height - [icon size].height) / 2;
        [icon compositeToPoint:offset operation:NSCompositeSourceOver];
      }
}

// ===========================================================================
// ==== Drag and drop methods
// ===========================================================================

- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender
{
    return NSDragOperationCopy;
}

- (void)draggingExited:(id <NSDraggingInfo>)sender
{
}

- (unsigned int)draggingUpdated:(id <NSDraggingInfo>)sender
{
    return NSDragOperationGeneric;
}

- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender
{
    return YES;
}

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender
{
    NSPasteboard *thePasteboard;
    NSArray *arrayOfFilePaths;
    NSDictionary *filesInformation;

    if (filename)
      {
        [filename release];
        filename=nil;
      }
    if (icon)
      {
        [icon release];
        icon=nil;
      }

    thePasteboard = [sender draggingPasteboard];

    if ([[thePasteboard types] indexOfObject:NSFilenamesPboardType] != NSNotFound)
      {
        arrayOfFilePaths = [thePasteboard propertyListForType:NSFilenamesPboardType];
        filesInformation = [NSDictionary dictionaryWithObjectsAndKeys:arrayOfFilePaths, @"Files", nil];

        filename = [[[thePasteboard propertyListForType:NSFilenamesPboardType] objectAtIndex:0] retain];
        [self setThinPath:(NSString *)filename];
        
        [[NSNotificationCenter defaultCenter] postNotificationName:DDViewFileDropped object:self userInfo:filesInformation];

        [self  setNeedsDisplay:YES];

        return YES;
      }
    return NO;
}

- (void)concludeDragOperation:(id <NSDraggingInfo>)sender
{
    [self display];
}

// ===========================================================================
// ==== Accessor methods
// ===========================================================================

- (void)setThinPath:(NSString *)aPath
{
    [thinPath autorelease];
    thinPath = [aPath copy]; 
}

- (NSString *)thinPath
{
    return thinPath;
}

@end
