/*
 Project:	UPlipo
 File:      DDView.h
 Creator:	Philippe C.D. Robert
 Created:   February 21, 1998

 Copyright: (c) 1998 by Philippe C.D. Robert, all rights reserved.

 GPL applies whithout any restrictions!
 */

#import <AppKit/AppKit.h>

extern NSString *DDViewFileDropped;

@interface DDView : NSView
{
    id filename;
    id icon;

    NSString *thinPath;
}

// ===========================================================================
// ==== Init & free methods
// ===========================================================================

- initWithFrame:(NSRect)aFrame;
- (void)dealloc;

// ===========================================================================
// ==== Drawing methods
// ===========================================================================

- (void)drawRect:(NSRect)aRect;

// ===========================================================================
// ==== Drag and drop methods
// ===========================================================================

- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender;
- (void)draggingExited:(id <NSDraggingInfo>)sender;
- (unsigned int)draggingUpdated:(id <NSDraggingInfo>)sender;
- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender;
- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender;
- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender;
- (void)concludeDragOperation:(id <NSDraggingInfo>)sender;

// ===========================================================================
// ==== Accessor methods
// ===========================================================================

- (void)setThinPath:(NSString *)aPath;
- (NSString *)thinPath;

@end
