/*
 Project:	UPlipo
 File:      AppController.m
 Creator:	Philippe C.D. Robert
 Created:   February 21, 1998

 Copyright: (c) 1998 by Philippe C.D. Robert,

 GPL applies whithout any restrictions!.
*/

#import "AppController.h"
#import "LipoManager.h"
#import "DDView.h"

#define UPLipoVersion @"0.7"

@implementation AppController

// ===========================================================================
// ==== Init & free methods
// ===========================================================================

- (id)init
{
    if (self = [super init])
      {
        lipoManager = [[LipoManager alloc] init];
        [lipoManager setDelegate:self];
        
        selectedArchType = 0; 							// PPC is default
        taskStatus = 0;
        
        workingPathString = [[NSString alloc] init];
      }
    return self;
}

- (void)dealloc
{
    [workingPathString release];
    [lipoManager release];
    
    [super dealloc];
}

// ===========================================================================
// ==== delegate methods
// ===========================================================================

- (void)awakeFromNib
{
    [version setStringValue:UPLipoVersion];
    [buttons setEnabled:NO];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(fileWasDropped:)
                                                 name: DDViewFileDropped object:dndBox];		

    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(setTaskStatus:)
                                                 name:NSTaskDidTerminateNotification
                                               object:nil];
}

// ===========================================================================
// ==== UI methods
// ===========================================================================

- (void)openInfoPanel:(id)sender
{
    [infoPanel center];
    [infoPanel makeKeyAndOrderFront:self];
}

- (void)appendStringToOutput:(NSString *)aString
{
    [infoText setString:[NSString stringWithFormat:@"%@%@\n", [infoText string], aString]];
    [infoText scrollRangeToVisible:NSMakeRange([[infoText textStorage] length], 0)];
}

- (void)fileWasDropped:(NSNotification *)aNotification
{
    [self appendStringToOutput:[NSString stringWithFormat:@"Target: %@", [[aNotification userInfo] objectForKey:@"Files"]]];
    [buttons setEnabled:YES];

    workingPathString = [(DDView *)dndBox thinPath];
}

- (void)pressButtons:(id)sender
{
    NSDirectoryEnumerator	*dirEnumerator;
    NSFileManager 			*fileManager;

    fileManager = [NSFileManager defaultManager];

    if(![fileManager changeCurrentDirectoryPath:workingPathString])
      {
        [self appendStringToOutput:@"Failed to change to the correct path!"];
      }

    dirEnumerator = [fileManager enumeratorAtPath:workingPathString];

    switch([[sender selectedCell] tag])
      {
        case 0:
            [lipoManager infoAboutExecutable:workingPathString args:@"-detailed_info"];
            break;
        case 1:
            [lipoManager infoAboutExecutable:workingPathString args:@"-info"];
            break;
        case 2:
            [lipoManager thinTargetExecutableAtPath:workingPathString targetArchitecture:(int)[self selectedArchType]];
      }
}

// ===========================================================================
// ==== Task methods
// ===========================================================================

- (void)setTaskStatus:(NSNotification *)aNotification
{
    taskStatus = [[aNotification object] terminationStatus];

    if (taskStatus == 0)
      {
        NSLog(@"lipo was successful!");
      }
    else
      {
        NSLog(@"lipo failed...");
      }
}

- (int)taskStatus
{
    return taskStatus;
}

// ===========================================================================
// ==== Accessor methods
// ===========================================================================

- (void)setSelectedArchType:(id)sender
{
    selectedArchType = [[sender selectedCell] tag];
}

- (int)selectedArchType
{
    return selectedArchType;
}

// ===========================================================================
// ==== Delegate methods
// ===========================================================================

- (void)lipoManager:(id)sender didLog:(NSString *)logString
{
    [self appendStringToOutput:logString];
}

@end
