/*
 Project:	UPlipo
 File:      AppController.h
 Creator:	Philippe C.D. Robert
 Created:   February 21, 1998

 Copyright: (c) 1998 by Philippe C.D. Robert, all rights reserved.

 GPL applies whithout any restrictions!
 */

#import <AppKit/AppKit.h>

@class LipoManager;

@interface AppController : NSObject
{
    id 	infoPanel;
    id	version;

    id 	dndBox;
    id 	infoText;
    id 	archType;
    id 	buttons;

    LipoManager				*lipoManager;
    NSString 				*workingPathString;

    int taskStatus;
    int selectedArchType;
}

// ===========================================================================
// ==== Init & free methods
// ===========================================================================

- (id)init;
- (void)dealloc;

// ===========================================================================
// ==== delegate methods
// ===========================================================================

- (void)awakeFromNib;
- (void)applicationDidFinishLaunching:(NSNotification *)aNotification;

// ===========================================================================
// ==== UI methods
// ===========================================================================

- (void)openInfoPanel:(id)sender;

- (void)appendStringToOutput:(NSString *)aString;
- (void)fileWasDropped:(NSNotification *)aNotification;

- (void)pressButtons:(id)sender;

// ===========================================================================
// ==== Task methods
// ===========================================================================

- (void)setTaskStatus:(NSNotification *)aNotification;
- (int)taskStatus;

// ===========================================================================
// ==== Accessor methods
// ===========================================================================

- (void)setSelectedArchType:(id)sender;
    // Sets the target architecture, 0 means ppc, 1 means i386 and 2 means i486

- (int)selectedArchType;

// ===========================================================================
// ==== Delegate methods
// ===========================================================================

- (void)lipoManager:(id)sender didLog:(NSString *)logString;

@end
