/*
 * Copyright 1998 by Kenneth C. Dyke
 *       All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN ACTION OF CONTRACT,
 * NEGLIGENCE, OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#import <AppKit/AppKit.h>
#import <driverkit/driverTypes.h>

@class IODeviceMaster;
@class IOConfigTable;

@interface G3Control : NSObject
{
    id cacheSizePopup;
    id clockRatioPopup;
    id enableButton;
    id enableOnRestartSwitch;
    id enableText;
    id modelPopup;
    id window;
    id writeThroughMatrix;
    id cpuSpeedField;
    id busSpeedField;
    id l2SpeedField;
    id cpuTemperatureField;
    id cpuImageView;
    id cpuSpeedHintField;

    NSImage			*_g3Image;
    NSImage			*_snailImage;
    
    IODeviceMaster	*_deviceMaster;
    IOConfigTable	*_cacheConfigTable;
    IOObjectNumber	_cacheDeviceNumber;
    
    NSBundle	*_driverBundle;
    NSMutableArray	*_modelArray;
    NSMutableDictionary	*_currentConfigurationDictionary;
    NSTimer		*_timer;
    
    BOOL		_driverRunning;
    BOOL		_cacheEnable;
    BOOL		_isRoot;

    unsigned long	_interval;
    unsigned long	_lastInterval;
    unsigned long	_temperature;
    unsigned long	_cpuHz;
    unsigned long	_busHz;
    
}

- (void)syncCurrentModelSettingsWithSystem;

- (void)updateUI;

- (void)setCacheSize:(unsigned int)size;
- (unsigned int)cacheSize;
- (void)setClockRatio:(unsigned int)ratio;
- (unsigned int)clockRatio;
- (void)setCacheEnabled:(BOOL)enabled;
- (BOOL)cacheEnabled;
- (void)setEnabledOnRestart:(BOOL)enabled;
- (BOOL)enabledOnRestart;
- (void)setWriteThrough:(BOOL)writeThrough;
- (BOOL)writeThrough;
- (unsigned int)cacheRAMType;
- (unsigned int)outputHold;
- (unsigned int)dllBypass;
- (BOOL)dllSlow;
- (BOOL)parityEnabled;
- (BOOL)differentialClock;
- (BOOL)cacheControlZZ;

- (void)enableCacheAction:(id)sender;
- (void)enableCacheOnRestartAction:(id)sender;
- (void)setCacheModeAction:(id)sender;
- (void)setCacheSizeAction:(id)sender;
- (void)setClockRatioAction:(id)sender;
- (void)setModelAction:(id)sender;
- (void)showInfoPanelAction:(id)sender;
- (void)setForwardingIntervalAction:(id)sender;

@end
