/*
 * Copyright 1998 by Kenneth C. Dyke
 *       All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN ACTION OF CONTRACT,
 * NEGLIGENCE, OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#import "PowerPCRegs.h"

static inline PVR readPVR(void)
{
    PVR r;
    __asm volatile("mfspr	%0,287" : "=r" (r.value) );
    return r;
}

static inline L2CR readL2CR(void)
{
    L2CR r;
    __asm volatile("mfspr	%0,1017" : "=r" (r.value) );
    return r;
}

static inline void writeL2CR(L2CR v)
{
    __asm volatile("mtspr	1017,%0" : /* no outputs */ : "r" (v.value) );
    __asm volatile("sync");
    __asm volatile("isync");
}

static inline HID0 readHID0(void)
{
    HID0 r;
    __asm volatile("mfspr	%0,1008" : "=r" (r.value) );
    return r;
}

static inline void writeHID0(HID0 v)
{
    __asm volatile("mtspr	1008,%0" : /* no outputs */ : "r" (v.value) );
    __asm volatile("isync");
}

static inline HID1 readHID1(void)
{
    HID1 r;
    __asm volatile("mfspr	%0,1009" : "=r" (r.value) );
    return r;
}

static inline MSR readMSR(void)
{
    MSR r;
    __asm volatile("mfmsr	%0" : "=r" (r.value) );
    return r;
}

static inline void writeMSR(MSR v)
{
    __asm volatile("mtmsr	%0" : /* no outputs */ : "r" (v.value) );
    __asm volatile("isync");
}

static inline PMC readPMC3(void)
{
    PMC r;
    __asm volatile("mfspr	%0,957" : "=r" (r.value) );
    return r;
}

static inline void writePMC3(PMC v)
{
    __asm volatile("mtspr	957,%0" : /* no outputs */ : "r" (v.value) );
}

static inline PMC readPMC4(void)
{
    PMC r;
    __asm volatile("mfspr	%0,958" : "=r" (r.value) );
    return r;
}

static inline void writePMC4(PMC v)
{
    __asm volatile("mtspr	958,%0" : /* no outputs */ : "r" (v.value) );
}

static inline MMCR1 readMMCR1(void)
{
    MMCR1 r;
    __asm volatile("mfspr	%0,956" : "=r" (r.value) );
    return r;
}

static inline void writeMMCR1(MMCR1 v)
{
    __asm volatile("mtspr	956,%0" : /* no outputs */ : "r" (v.value) );
}

static inline THRM readTHRM1(void)
{
    THRM r;
    __asm volatile("mfspr	%0,1020" : "=r" (r.value) );
    return r;
}

static inline void writeTHRM1(THRM v)
{
    __asm volatile("mtspr	1020,%0" : /* no outputs */ : "r" (v.value) );
}

static inline THRM readTHRM2(void)
{
    THRM r;
    __asm volatile("mfspr	%0,1021" : "=r" (r.value) );
    return r;
}

static inline void writeTHRM2(THRM v)
{
    __asm volatile("mtspr	1021,%0" : /* no outputs */ : "r" (v.value) );
}

static inline THRM3 readTHRM3(void)
{
    THRM3 r;
    __asm volatile("mfspr	%0,1022" : "=r" (r.value) );
    return r;
}

static inline void writeTHRM3(THRM3 v)
{
    __asm volatile("mtspr	1022,%0" : /* no outputs */ : "r" (v.value) );
}

static inline ICTC readICTC(void)
{
    ICTC r;
    __asm volatile("mfspr	%0,1019" : "=r" (r.value) );
    return r;
}

static inline void writeICTC(ICTC v)
{
    __asm volatile("mtspr	1019,%0" : /* no outputs */ : "r" (v.value) );
}
