/*
    File:       DualRoleTask_main.h

    Contains:   A simple application that uses NSTask.

    Written by: Quinn "The Eskimo!"

    Created:    23 Sep 1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

int ToolMain(int argc, const char *argv[])
    // The main line for the tool.  It's a very simple
    // "print your arguments" routine, but you could
    // potentially do a lot more here, just as running
    // a Distributed Objects event loop.
{
    int i;

    for (i = 0; i < argc; i++) {
        printf("argv[%d] is <%s>.\n", i, argv[i]);
    }

    return 0;
}

int main(int argc, const char *argv[]) {

    // If we receive the magic option, run as a tool instead
    // of as a real application.
    
    if (argc > 1 && strcmp(argv[1], "-RunBackground") == 0) {
        return ToolMain(argc, argv);
    } else {
        return NSApplicationMain(argc, argv);
    }
}
