#import <AppKit/AppKit.h>

#import "IKIconObject.h"
#import "IKDependency.h"

enum {
	IK_NOPART,
	IK_TITLEPART,
	IK_ICONPART
};

enum {
	IK_NOSHELF,
	IK_UNLOCKED,
	IK_LOCKED,
	IK_REALLYLOCKED
};

typedef struct _cellflags {
		unsigned int	showMiniImage:1;
		unsigned int	showBranch:1;
		unsigned int	draggable:1;
		unsigned int	dragAccepting:1;
		unsigned int	editable:1;
		unsigned int	container:1;
		unsigned int	locked:1;
		unsigned int	reallyLocked:1;
		unsigned int	multipleLines:1;
		unsigned int	ghosted:1;
} cellFlags;

@interface IKCell : NSActionCell
{
	id <IKIconObject, IKDependency> delegate;
	
	id			image;
	id			miniImage;
	cellFlags	flags;
}

+ (void)initialize;
- init;
- initTextCell:(NSString *)theTitle;
- initImageCell:(NSImage *)image;
- initImage: (NSImage *)theImage title:(NSString *)theTitle;
- initDelegate: (id <IKIconObject, IKDependency>) theDelegate;
- initFromCopy: (IKCell *) copy;
- (void)dealloc;
- (NSString *) inspectorClassName;
- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;
- delegate;
- (NSImage *)image;
- (NSImage *)miniImage;
- (NSString *)title;
- (BOOL) isShowMiniImage;
- (BOOL) isBranch;
- (BOOL) isContainer;
- (BOOL) isLocked;
- (BOOL) isReallyLocked;
- (BOOL) isEmptyContainer;
- (BOOL) isMultipleLines;
- (BOOL) isGhosted;
- (BOOL) isDraggable;
- (BOOL) isDragAccepting;
- (BOOL) isEditable;
- (void)setImage:(NSImage *)theImage;
- (void)setMiniImage: (NSImage *) theImage;
- (void)setTitle:(NSString *)theTitle;
- setShowMiniImage:(BOOL)flag;
- setBranch:(BOOL)flag;
- setDraggable:(BOOL)flag;
- setDragAccepting:(BOOL)flag;
- (void)setEditable:(BOOL)flag; ;
- setContainer:(BOOL)flag;
- setLocked:(BOOL)flag;
- setReallyLocked:(BOOL)flag;
- setMultipleLines:(BOOL)flag;
- setGhosted:(BOOL)flag;
- (void)setDelegate:(id)theDelegate;
- willFree: who;
- (int) shelfMode;
- setShelfMode: (int) mode;
- didChangeName: sender;
- didChangeImage: sender;
- didChangeMiniImage: sender;
- (void)highlight:(BOOL)flag withFrame:(NSRect)cellFrame inView:(NSView *)view;
- (NSImage *)_imageToDraw;
- (void)drawInteriorWithFrame:(NSRect)cellFrame inView:(NSView *)view;
- (void)drawIcon: (NSRect) iconRect;
- (void)drawTitle: (NSRect) titleRect;
- (void)drawBranch: (NSRect) cellFrame;
- (NSSize)cellSizeForBounds:(NSRect)frame;
- _getIconRect: (NSRect *) iconRect  titleRect: (NSRect *) titleRect;
- (NSRect)imageRectForBounds:(NSRect)iconRect;
- (NSRect)titleRectForBounds:(NSRect)titleRect;
- (int) hitPart: (NSPoint *) where  inRect: (const NSRect *) cellFrame;
- dragIcon:(NSEvent *)event  inRect: (const NSRect *) cellFrame  ofView: view;
- editTitle:(NSEvent *)event  inRect:(const NSRect *) cellFrame  ofView: view;
- editor;

@end

