#import <Foundation/NSObject.h>
#import <Foundation/NSArray.h>
#import "IKDependency.h"
@class IKFolder;

@interface IKAnnouncer:NSObject
<IKDependency>
{
		IKFolder		*owner;
		NSMutableArray	*usersAndListeners;
		int				numUsers;
		BOOL			sendAnnouncements;
}
- (IKAnnouncer *)initOwner: theOwner;
- (void)dealloc;
- (NSMutableArray *)usersAndListeners;
- (int) numUsers;
- (BOOL) sendAnnouncements;
- (void)setSendAnnouncements: (BOOL) flag;
- (BOOL)isUser:who;
- (void)addUser: who;
- (void)addListener: who;
- (void)removeUser: who;
- (void)removeListener: who;
- (void)announce: (SEL) message;
- (void)announce:(SEL)message with: arg;
- (BOOL)poll:(SEL)message;
- (BOOL) poll: (SEL) message  with: arg;

@end

