// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Pipelines.subproj/OWWebPipeline.h,v 1.4 1998/12/08 04:05:55 kc Exp $

#import "OWPipeline.h"

typedef enum {
    OWWebPipelineForwardHistoryAction,
    OWWebPipelineBackwardHistoryAction,
    OWWebPipelineReloadHistoryAction
} OWWebPipelineHistoryAction;

@interface OWWebPipeline : OWPipeline
{
    OWWebPipelineHistoryAction historyAction;
    OWContentInfo *referringContentInfo;
    id <OWAddress> referringAddress;

    struct {
        unsigned int proxyCacheDisabled:1;
    } webPipelineFlags;
}

- (OWWebPipelineHistoryAction)historyAction;
- (void)setHistoryAction:(OWWebPipelineHistoryAction)newHistoryAction;

- (id <OWAddress>)referringAddress;
- (void)setReferringAddress:(id <OWAddress>)anAddress;

- (OWContentInfo *)referringContentInfo;
- (void)setReferringContentInfo:(OWContentInfo *)anInfo;

- (BOOL)proxyCacheDisabled;
- (void)setProxyCacheDisabled:(BOOL)newDisabled;

@end
