// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Pipelines.subproj/OWContentType.h,v 1.5 1998/12/08 04:05:51 kc Exp $

#import <OmniFoundation/OFObject.h>

@class OWContentTypeLink;
@class NSArray, NSMutableArray, NSMutableSet, NSSet, NSString;

#import <Foundation/NSDate.h> // For NSTimeInterval

@interface OWContentType : OFObject
{
    NSString *contentTypeString;
    unsigned int hash;
    NSMutableSet *links;
    NSMutableSet *reverseLinks;
    NSArray *extensions;
    NSTimeInterval expirationTimeInterval;

    NSString *imageName;
    NSString *readableString;
    
    BOOL isEncoding;
    BOOL isPublic;
}

+ (OWContentType *)contentTypeForString:(NSString *)aString;
+ (OWContentType *)wildcardContentType;
+ (NSArray *)contentEncodings;
+ (void)setDefaultExpirationTimeInterval:(NSTimeInterval)newTimeInterval;
+ (void)updateExpirationTimeIntervalsFromDefaults;

+ (OWContentTypeLink *)linkForTargetContentType:(OWContentType *)targetContentType fromContentType:(OWContentType *)sourceContentType orContentTypes:(NSSet *)sourceTypes;

+ (OWContentType *)contentTypeForExtension:(NSString *)extension;
+ (OWContentType *)contentTypeForFilename:(NSString *)filename;
- (void)setExtensions:(NSArray *)someExtensions;
- (NSArray *)extensions;
- (NSString *)primaryExtension;

- (void)setImageName:(NSString *)newImageName;
- (NSString *)imageName;

- (NSString *)contentTypeString;
- (NSString *)readableString;
- (BOOL)isEncoding;
- (BOOL)isPublic;

- (void)linkToContentType:(OWContentType *)targetContentType usingProcessorClassName:(NSString *)aProcessorClassName cost:(float)aCost;

- (NSTimeInterval)expirationTimeInterval;
- (void)setExpirationTimeInterval:(NSTimeInterval)newTimeInterval;

- (NSSet *)directSourceContentTypes;
- (NSSet *)indirectSourceContentTypes;

- (NSString *)pathForEncoding:(OWContentType *)contentEncoding givenOriginalPath:(NSString *)aPath;

@end

#import "FrameworkDefines.h"

OWF_EXTERN NSTimeInterval OWContentTypeNeverExpireTimeInterval;
OWF_EXTERN NSTimeInterval OWContentTypeExpireWhenFlushedTimeInterval;
OWF_EXTERN NSString *OWContentTypeNeverExpireString;
OWF_EXTERN NSString *OWContentTypeExpireWhenFlushedString;
OWF_EXTERN NSString *OWContentTypeReloadExpirationTimeIntervalsNotificationName;
