// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Content.subproj/OWObjectTree.h,v 1.2 1998/12/08 04:05:44 kc Exp $

#import "OWObjectTreeNode.h"
#import "OWContentProtocol.h"
#import <OmniFoundation/OFSimpleLock.h>

@interface OWObjectTree : OWObjectTreeNode <OWContent>
{
    OWContentType *nonretainedContentType;
    OWContentInfo *contentInfo;
    OFSimpleLockType mutex;
}

- initWithRepresentedObject:(NSObject *)object;

- (void)setContentType:(OWContentType *)aType;
- (void)setContentTypeString:(NSString *)aString;

@end

// Only for use by OWObjectTreeNode
@interface OWObjectTree (lockAccess)
- (OFSimpleLockType *)mutex;
@end
