// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWFileInfo.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OWAddress.h"
#import "OWContentType.h"
#import "OWURL.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Content.subproj/OWFileInfo.m,v 1.3 1998/12/08 04:05:43 kc Exp $")

@implementation OWFileInfo

static OWContentType *OWFileInfoContentType;

+ (void)initialize;
{
    static BOOL                 initialized = NO;

    [super initialize];
    if (initialized)
        return;
    initialized = YES;

    OWFileInfoContentType = [OWContentType contentTypeForString:@"OWObject/OWFileInfo"];
}

+ (OWContentType *)contentType;
{
    return OWFileInfoContentType;
}

- initWithAddress:(OWAddress *)anAddress size:(NSNumber *)aSize isDirectory:(BOOL)isDirectory isShortcut:(BOOL)isShortcut lastChangeDate:(NSDate *)aDate;
{
    if (![super init])
        return nil;

    address = [anAddress retain];
    size = [aSize retain];
    flags.isDirectory = isDirectory;
    flags.isShortcut = isShortcut;
    lastChangeDate = [aDate retain];

    return self;
}

- (void)dealloc;
{
    [address release];
    [size release];
    [lastChangeDate release];
    [cachedName release];
    [super dealloc];
}

- (OWAddress *)address;
{
    return address;
}

- (NSNumber *)size;
{
    return size;
}

- (BOOL)isDirectory;
{
    return flags.isDirectory;
}

- (BOOL)isShortcut;
{
    return flags.isShortcut;
}

- (NSDate *)lastChangeDate;
{
    return lastChangeDate;
}

// Derived attributes

- (NSString *)name;
{
    if (!cachedName)
        cachedName = [[OWURL decodeURLString:[[address url] lastPathComponent]] retain];
    return cachedName;
}

- (NSString *)addressString;
{
    return [address addressString];
}

// OWContent protocol

- (OWContentType *)contentType;
{
    return OWFileInfoContentType;
}

- (OWContentInfo *)contentInfo;
{
    return nil;
}

- (unsigned long int)cacheSize;
{
    return 100;
}

- (BOOL)shareable;
{
    return YES;
}

@end
