// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Content.subproj/OWDocumentTitle.h,v 1.3 1998/12/08 04:05:42 kc Exp $

#import "OWAbstractContent.h"

@class NSString, OWContentType;

#import "OWAddressProtocol.h"

// Use content-types "DocumentTitle/Guess" and "DocumentTitle/Real" for titles that are obtained from anchors and actual document titles, respectively.

@interface OWDocumentTitle : OWAbstractContent
{
    NSString *title;
    OWContentType *type;
}

// Accessing titles
+ (void)cacheRealTitle:(NSString *)aTitle forAddress:(id <OWAddress>)anAddress;
+ (void)cacheGuessTitle:(NSString *)aTitle forAddress:(id <OWAddress>)anAddress;
+ (NSString *)titleForAddress:(id <OWAddress>)address;

// Notifications of changes to titles
+ (void)addObserver:(id)anObserver selector:(SEL)aSelector address:(id <OWAddress>)anAddress;
+ (void)removeObserver:(id)anObserver address:(id <OWAddress>)anAddress;
+ (void)removeObserver:(id)anObserver;

//
- initWithTitle:(NSString *)aTitle contentType:(OWContentType *)aType;
- (NSString *)title;

@end

