/**
 * OpenAmp Play List
 *
 * Wilfredo Sanchez | wsanchez@apple.com
 * September 22, 1998
 **/

#import <AppKit/NSDocument.h>
#import <AppKit/NSNibDeclarations.h>

@class NSData;
@class NSString;
@class NSMutableArray;
@class NSMatrix;
@class NSButton;
@class AudioFile;

@interface PlayList : NSDocument

{
@private
    NSMutableArray* myPlayList;

    // IB Outlets
    IBOutlet NSWindow* playListWindow;
    IBOutlet NSMatrix* listMatrix;
    IBOutlet NSButton* listUpButton;
    IBOutlet NSButton* listDownButton;
    IBOutlet NSButton* listDeleteButton;
    IBOutlet NSButton* listAddButton;
}

/**
 * Inits
 **/

- (id) init;

/**
 * Accessors
 **/

- (NSArray*  ) audioFiles;
- (AudioFile*) selectedAudioFile;
- (AudioFile*) selectFirstAudioFile;
- (AudioFile*) selectPreviousAudioFile;
- (AudioFile*) selectNextAudioFile;
- (BOOL      ) hasPrevious;
- (BOOL      ) hasNext;

- (void) addAudioFile: (AudioFile*) aFile;

/**
 * Actions
 **/

- (BOOL) readFromFile: (NSString*) aFileName
               ofType: (NSString*) aType;
- (BOOL) writeToFile: (NSString*) aFileName
              ofType: (NSString*) aType;

- (void) close;

/**
 * IB Actions
 **/

- (IBAction) playListSelectItem  : (id) aSender;
- (IBAction) playListPromoteItem : (id) aSender;
- (IBAction) playListDemoteItem  : (id) aSender;
- (IBAction) playListAddItem     : (id) aSender;
- (IBAction) playListDeleteItem  : (id) aSender;

@end
