/**
 * Foundation and AppKit extensions
 **
 * Wilfredo Sanchez | wsanchez@apple.com
 **/

#import "Extentions.h"

/************
 * NSString *
 ************/

@implementation NSString (PropertyListEncoding)

- (NSString*) quotedString
{
    NSMutableString* aMutableCopy = [[self mutableCopy] autorelease];

    if (aMutableCopy)
      {
        [aMutableCopy replaceSubstring:@"\\" withString:@"\\\\" globally:YES];
        [aMutableCopy replaceSubstring:@"\"" withString:@"\\\"" globally:YES];

        [aMutableCopy replaceCharactersInRange:NSMakeRange(                    0,0) withString:@"\""];
        [aMutableCopy replaceCharactersInRange:NSMakeRange([aMutableCopy length],0) withString:@"\""];
      }
    return aMutableCopy;
}

@end

@implementation NSMutableString (Substitution)

- (void) replaceSubstring: (NSString*   ) aSubstring
               withString: (NSString*   ) aString
                 globally: (BOOL        ) aGlobally
{
    [self replaceSubstring: aSubstring
                withString: aString
                  globally: aGlobally
                   options: (unsigned int)0];
}
- (void) replaceSubstring: (NSString*   ) aSubstring
               withString: (NSString*   ) aString
                 globally: (BOOL        ) aGlobally
                  options: (unsigned int) anOptions
{
    NSRange aRange = [self rangeOfString:aSubstring options:anOptions];

    if (aGlobally)
      {
        if (anOptions & NSBackwardsSearch)
          {
            NSRange aSearchRange;

            aSearchRange.location = 0;

            while (aRange.length)
              {
                [self replaceCharactersInRange:aRange withString:aString];

                aSearchRange.length = aRange.location;

                aRange = [self rangeOfString:aSubstring options:anOptions range:aSearchRange];
              }
          }
        else
          {
            while (aRange.length)
              {
                [self replaceCharactersInRange:aRange withString:aString];

                aRange = [self rangeOfString: aSubstring
                                     options: anOptions
                                       range: NSMakeRange(aRange.location+1,
                                                          [self length] - (aRange.location+1))];
              }
          }
      }
    else
      {
        if (aRange.length) [self replaceCharactersInRange:aRange withString:aString];
      }
}

- (void) deleteSubstring: (NSString*   ) aSubstring
                globally: (BOOL        ) aGlobally
{
    [self deleteSubstring: aSubstring
                 globally: aGlobally
                  options: (unsigned int)0];
}
- (void) deleteSubstring: (NSString*   ) aSubstring
                globally: (BOOL        ) aGlobally
                 options: (unsigned int) anOptions
{
    NSRange aRange = [self rangeOfString:aSubstring options:anOptions];

    if (aGlobally)
      {
        while (aRange.length)
          {
            [self deleteCharactersInRange: aRange];

            aRange = [self rangeOfString:aSubstring options:anOptions];
          }
      }
    else
      {
        if (aRange.length) [self deleteCharactersInRange: aRange];
      }
}

@end

/***********
 * NSArray *
 ***********/

#import <Foundation/NSEnumerator.h>

@implementation NSArray (Filter)

- (NSArray*) subarrayUsingSelector: (SEL) aFilter
{
    NSMutableArray* anArray      = [NSMutableArray array];
    NSEnumerator*   anEnumerator = [self objectEnumerator];
    NSObject*       anObject;

    while ((anObject = [anEnumerator nextObject]))
        if ([anObject performSelector:aFilter])
            [anArray addObject: anObject];

    return anArray;
}

@end

/***********
 * NSPanel *
 ***********/

#import <Foundation/NSString.h>

@implementation NSPanel (Alert)

+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage
{
    [self runAlertPanelWithName: aName
                        message: aMessage
            defaultButtonString: nil
          alternateButtonString: nil
              otherButtonString: nil];
}
+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage
           defaultButtonString: (NSString*) aDefaultButtonString
{
    [self runAlertPanelWithName: aName
                        message: aMessage
            defaultButtonString: aDefaultButtonString
          alternateButtonString: nil
              otherButtonString: nil];
}
+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage
           defaultButtonString: (NSString*) aDefaultButtonString
         alternateButtonString: (NSString*) anAlternateButtonString
{
    [self runAlertPanelWithName: aName
                        message: aMessage
            defaultButtonString: aDefaultButtonString
          alternateButtonString: anAlternateButtonString
              otherButtonString: nil];
}
+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage
           defaultButtonString: (NSString*) aDefaultButtonString
         alternateButtonString: (NSString*) anAlternateButtonString
             otherButtonString: (NSString*) anOtherButtonString
{
    NSRunAlertPanel(aName,
                    aMessage,
                    aDefaultButtonString,
                    anAlternateButtonString,
                    anOtherButtonString,
                    nil);
}

@end
