/**
 * OpenAmp Console Controller
 *
 * Wilfredo Sanchez | wsanchez@apple.com
 * September 26, 1998
 **/

#import <Foundation/NSObject.h>

@class SoundDecoder;
@class PlayList;
@class AudioFile;
@class NSWindow;
@class NSSlider;
@class NSButton;
@class NSProgressIndicator;
@class NSTextField;
@class NSLock;

typedef enum {
    STOPPED,
    PLAYING,
    PAUSED,
} PlayState;

@interface ConsoleController : NSObject

{
@private
    SoundDecoder* myDecoder;
    PlayList*     myPlayList;
    PlayState     myState;
    NSLock*       myLock;

    // IB Outlets
    IBOutlet NSWindow*            window;
    IBOutlet NSSlider*            volumeSlider;
    IBOutlet NSSlider*            balanceSlider;
    IBOutlet NSButton*            repeatButton;
    IBOutlet NSButton*            shuffleButton;
    IBOutlet NSButton*            previousTrackButton;
    IBOutlet NSButton*            nextTrackButton;
    IBOutlet NSButton*            playButton;
    IBOutlet NSButton*            pauseButton;
    IBOutlet NSButton*            stopButton;
    IBOutlet NSProgressIndicator* progressBar;
    IBOutlet NSTextField*         timeDisplay;
    IBOutlet NSTextField*         totalTimeDisplay;
    IBOutlet NSTextField*         titleDisplay;
}

/**
 * Inits
 **/

- (id) init;

/**
 * Accessors
 **/

- (PlayList* ) playList;
- (PlayState ) state;
- (AudioFile*) currentTrack;

- (void) setPlayList: (PlayList*) aValue;

- (void) setProgressIsIndeterminate: (BOOL) anIndeterminateFlag;

/**
 * Actions
 **/

- (AudioFile*) nextTrack;
- (AudioFile*) previousTrack;

- (void) updateProgressWithValue: (double) aValue
                             max: (double) aTotal;

- (void) updateTimeWithValue      : (time_t) aValue;
- (void) updateTotalTimeWithValue : (time_t) aValue;

/**
 * IB Actions
 **/

- (IBAction) volumeChanged : (id) aSender;
- (IBAction) selectShuffle : (id) aSender;
- (IBAction) previousTrack : (id) aSender;
- (IBAction) nextTrack     : (id) aSender;
- (IBAction) play          : (id) aSender;
- (IBAction) pause         : (id) aSender;
- (IBAction) stop          : (id) aSender;

/**
 * Decoder notices
 **/

- (void) donePlaying;

@end
