/**
 * OpenAmp Audio File
 *
 * Wilfredo Sanchez | wsanchez@apple.com
 * September 24, 1998
 **/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#import "Extentions.h"
#import "ApplicationController.h"
#import "PlayList.h"
#import "AudioFile.h"

@interface AudioFile (Private)

// Accessors
- (void) setFileName: (NSString*) aValue;

@end

@implementation AudioFile

/**
 * Factories
 **/

+ (AudioFile*) file
{
    return [[(AudioFile*)[self alloc] init] autorelease];
}

/**
 * Inits
 **/

- (id) init
{
    if ((self = [super init]))
      {
        myFileName = nil;
      }
    return self;
}

- (void) dealloc
{
    [ myFileName release ];

    [super dealloc];
}

/**
 * Accessors
 **/

- (NSString*) title
{
    return [[myFileName lastPathComponent] stringByDeletingPathExtension];
}

- (NSString*) filename  { return myFileName; }
- (NSString*) artist    { return nil       ; }
- (NSString*) album     { return nil       ; }
- (NSString*) copyright { return nil       ; }
- (NSString*) info      { return nil       ; }

- (NSString*) description { return [myFileName quotedString]; }

- (void) setFileName: (NSString*) aValue
{
    // We don't read the file contents in this class; rather, we just
    // store information about the file.
    setAndRetain(myFileName, aValue);
}

/**
 * Actions
 **/

- (BOOL) readFromFile: (NSString*) aFileName
               ofType: (NSString*) aType
{
    NSAssert([aType isEqualToString: @"MPEGLayerIIIAudio"], @"Unknown data type: %@");

    [self setFileName: aFileName];

    {
        PlayList* aPlayList = [TheApplicationController activePlayList];

        if (! aPlayList)
            aPlayList = [TheApplicationController newPlayList];

        if (aPlayList)
            [aPlayList addAudioFile: self];
        else
            return NO;
    }

    return YES;
}

- (BOOL) writeToFile: (NSString*) aFileName
              ofType: (NSString*) aType
{
    NSAssert([aType isEqualToString: @"MPEGLayerIIIAudio"], @"Unknown data type: %@");

    // This is a viewer class, and doesn't write files.
    return NO;
}

@end
