/**
 * OpenAmp Application Controller
 *
 * Wilfredo Sanchez | wsanchez@apple.com
 * September 25, 1998
 **/

#import <Foundation/NSObject.h>

@class PlayList;
@class ConsoleController;

@interface ApplicationController : NSObject

{
@private
    PlayList*          myActivePlayList;
    ConsoleController* myConsoleController;
}

/**
 * Inits
 **/

- (id) init;

/**
 * Accessors
 **/

- (PlayList*         ) activePlayList;
- (ConsoleController*) consoleController;

- (void) setActivePlayList: (PlayList*) aValue;

/**
 * Actions
 **/

- (PlayList*) newPlayList;

- (void) playListDidClose: (PlayList*) aPlayList;

@end

#define TheApplicationController (ApplicationController*)[NSApp delegate]
