/*
 * TestController.h -- for demonstrating and exercising the WriteUp API.
 * Written originally by Kris Younger, updated for OPENSTEP/Yellow Box
 * by Greg Anderson (September 1997).
 *
 * See TestController.m for a full description of what this module does.
 */
#import <AppKit/AppKit.h>

@interface TestController:NSObject
	{
	id writeup;				// remote proxy to WriteUp application
	id textPasteField;	// allows user to specify the text be be pasted
	id hostnameField;		// allows user to specify where to run the demo
	}

/* [NSApp delegate] notifications */
- (void)applicationDidFinishLaunching:(NSNotification *)aNotification;
- (void)applicationWillTerminate:(NSNotification *)aNotification;

/* test methods */
- (void)runCutPasteStylesTest:sender;
- (void)runHeadersFootersColumnsTest:sender;
- (void)runSimpleTableTest:sender;
- (void)runSimpleSelectionTest:sender;
- (void)runExtendedSelectionTest:sender;
- (void)runGraphicsTest:sender;

@end
