/*
	Copyright 1995, Anderson Financial Systems Inc.  All Rights Reserved.
	Anderson Financial Systems, Inc.
	909 Sumneytown Pike, Suite 106
	Springhouse, PA 19477
	215 653 0911
 */

/* Paragraph keeps a list of words inside itself. You can access the
 * words through the following methods. Bear in mind that wordCount and
 * what's on the list may change (via Copy,  Paste, etc.) It's always a good
 * idea to "re-fetch" these object when in doubt.
 */
@class TextWord;
#import "StyleAccess_Protocol.h"
#import "WordAccess_Protocol.h"

@protocol ParagraphAccess

	/* Frees the resource for the flow
	 */
- (void)freeResource;

	/* wordcount returns the number of words in the list. 
	 */
- (int)wordCount;

	/* wordAtIndex: returns the word object at idx in the list. 
	 */
- (TextWord *)wordAtIndex:(int)idx;

	/* paragraphStyle returns the style object for the paragraph. 
	 */
- (id <StyleAccess>)paragraphStyle;

	/* returns true if the para is styled with a named style. 
	 */
- (BOOL)isNameStyled;

	/* returns the name of the style. 
	 */
- (NSString *)styleName;

	/* sets the name of the style. 
	 */
- (void)setStyleName:(NSString *)aNewName;

	/* Page Number of the Paragraph's first appearance . 
	 */
- (int)pageNumber;

	/* force a separation of a paragraph from it's style. it becomes freeform. 
	 */
- (void)localizeNamedParaStyle:sender;

	/* true if the paragraph has no words. not true even if there
	 * is blanks or tabs. 
	 */
- (BOOL)isEmpty;

	/* sets a paragraph to have a named style. 
	 */
- (void)setStylePara:(id <StyleAccess>)aStyle;

	/* lets the document know that this paragraph needs to be
	 * recomputed next time around. 
	 */
- (void)setDirty:(BOOL)yn;

@end

