/* Copyright (C) 1999 Steyla Technologies, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as
   published by the Free Software Foundation, Inc.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#import "CSucaba.h"
#import <math.h>

int	nptr=0;
int nAfterPeriod=0;
char	operator=0;
char	lastOperator=0;
MDOUBLE	dValue[2];
char	sValue[2][100];
int	dPart=0;
char	sMemory[100];
char	backMemory[100];



BOOL isValueAfterPeriod(MDOUBLE numb)
{
    char	s[100];
    int 	i;
    
    sprintf(s,"%f",numb);

    for(i=0;s[i];i++)
      {
        if((s[i] == '.') && s[i+1])
            if(atoi(&s[i+1]))
              {
                return TRUE;
              }
          
      }
    return FALSE;
}

void rtrimZero(char *s)
{
    int	i;
    int	l=0;

    if(!(strchr(s,'.')))
        return;

    l=strlen(s)-1;

    for(i=l;i>0;i--)
      {
         if(s[i]=='.')
          {
            if(!s[i+1])
                s[i]=0;
            break;
          }

        if(s[i]=='0')
            s[i]=0;
        if((s[i] > 48) && (s[i] < 58))
            break;
      }
 }

void rtrim(char *s)
{
    int	i;
     int	l=0;

     l=strlen(s)-1;

     for(i=l;i>0;i--)
       {
//NSLog(@"char=[%d]",s[i]);
         if(s[i]==32)
             s[i]=0;
         if(s[i]!=32)
             break;
       }

     


}

void stripLF(char *s)
{
    if(s[strlen(s)-1] == '\n')
        s[strlen(s)-1] =0;
}

@interface NSWindow (Helper)
- (BOOL)windowShouldClose:(id)sender;
@end

@implementation NSWindow (Helper)
- (BOOL)windowShouldClose:(id)sender
{

    NSLog(@"Closing Sucaba");

    return TRUE;
}
@end


@implementation CSucaba

- (void)copyItem:(id)sender;
{
    NSPasteboard *itempb;

    itempb = [NSPasteboard pasteboardWithName:NSGeneralPboard];
    [itempb declareTypes:[NSArray arrayWithObject:NSStringPboardType] owner:nil];
    if(!([itempb setString:outBuffer forType:NSStringPboardType]))
        NSLog(@"Copy - Unable to copy data");


}

- (void)pasteItem:(id)sender
{
    char	s[100];
    NSPasteboard *itempb;
    NSString *ns;
    itempb = [NSPasteboard pasteboardWithName:NSGeneralPboard];
    if ([[itempb types] containsObject:NSStringPboardType])
      {
        ns=[itempb stringForType:NSStringPboardType];
        if([ns length] < 100)
          {
            [ns getCString:s];
            if(![self checkInString:s])
                [self addValues:ns];
            else
              {
                NSLog(@"Paste - Wrong data '%s'. Only -1234567890 alowed.",s);
                NSBeep();
              }
          }
      }

}


- init
{
    [super init];
    [self clear];
    outBuffer=[[NSMutableString alloc]init];
  //  [outField setStringValue:@"0"];

          
    strcpy(backMemory,"0");
    strcpy(sMemory,"0");
    strcpy(sValue[0],"0");
    strcpy(sValue[1],"0");
    dPart=0;
    
  
    return self;
}


- clear
{
    [ outBuffer release];
    return self;
}


- (void)addValues:(NSString *)string
{
    char	s[100];

    
    [outBuffer getCString:s];

    if(strlen(s) >= MAX_AFTER_PERIOD)
        return;

     
    if(operator == 'C')
      {
        [outBuffer setString:@""];
        operator=0;
      }
    [outBuffer appendString:string];
    [self printStringValue:outBuffer];


    [self getStringValue];
    
    //NSLog(@"sValue=[%s]",sValue[dPart]);
    //NSLog(outBuffer);
        
    dValue[dPart]=[outField doubleValue];
  
    return ;
}

- (void)getStringValue
{
    NSString	*string;

    string=[outField stringValue];

    [string getCString:sValue[dPart]];

   

}

- (MDOUBLE) getDouble:(NSString *)string
{
    char	*s;
    int		length=0;
    MDOUBLE	retval=0;
    
    length=[string length];

 
    s=(char *)malloc(length+1);

    [string getCString:s];

    retval=atof(s);

    free(s);

    return (MDOUBLE)retval;
    
}


- (void)piButton:(id)sender
{
    char	*rets;

    rets=[self calcBC:"scale=32; 4*a(1)"];
    strcpy(sMemory,rets);

    [self printCStringValue:rets];

    [outBuffer initWithCString:rets];

    lastOperator=operator;
    strcpy(sValue[0],sMemory);
    dPart=1;

}

- (void)calcNow:(char)value
{
    char	s[256];
    char	*retstring;

    if(strlen(sMemory) >MAX_AFTER_PERIOD)
      {
        NSBeep();
        return;
      }

    //NSLog(@"In calcNow. Operator=[%c]",operator);
    switch(value)
      {
        case '%':
            if(dPart)
                {

                sprintf(s,"(%s/100)*%s",sValue[0],sValue[1]);
                //NSLog(@"<%s>",s);
                retstring=[self calcBC:s];
                //NSLog(@"retstring=[%s]",retstring);
                [outBuffer initWithCString:retstring];
                strcpy(sValue[1],retstring);
                }
            break;
        case '=':
            if(dPart)
              {
                sprintf(s,"%s%c%s",sValue[0],lastOperator,sValue[1]);
                //NSLog(@"<%s>",s);
                retstring=[self calcBC:s];
                strcpy(sMemory,retstring);
                //NSLog(@"sMemory=[%s]",sMemory);
                strcpy(sValue[0],sMemory);
                operator=0;
               }
            break;

        case '+':
        case '-':
        case '*':
        case '/':
            if(dPart)
              {
                sprintf(s,"%s%c%s",sValue[0],operator,sValue[1]);
                //NSLog(@"<%s>",s);
                retstring=[self calcBC:s];
                strcpy(sMemory,retstring);
                //NSLog(@"sMemory=[%s]",sMemory);
                strcpy(sValue[0],sMemory);
             //   strcpy(sValue[1],"0");
              }
            break;
      }

   [self printStringValue:outBuffer];
}

- (char *)calcBC:(char *)s
{
    FILE	*p;
    char	command[256];
    static	char	retstring[256];

    sprintf(command,"%s \"scale=32;%s\"|%s 2>&1 ",CMD_ECHO,s,CMD_BC);

    if([self checkFilePath:CMD_ECHO])
      {
        [self printErrorMessage:retstring];
        retstring[0]='0';
        retstring[1]=0;
        [outBuffer setString:@""];
        return retstring;
      }
    
    if(!(p=popen(command,"r")))
        return NULL;

    fgets(retstring,255,p);

    fclose(p);

    stripLF(retstring);
    rtrimZero(retstring);
    
    //NSLog(@"stdin <%s>",retstring);
    if(!retstring[0])
        strcpy(retstring,"0");
   
   
    [self checkIsZero:retstring];
    if([self checkInString:retstring])
      {
        [self printErrorMessage:retstring];
        retstring[0]='0';
        retstring[1]=0;
        [outBuffer setString:@""];

      }

    return retstring;

}

- (void)printErrorMessage:(char *)s
{
    NSMutableString *string=[[NSMutableString alloc]init];

    [string initWithCString:s];
    NSRunAlertPanel(@"Error",string,nil,nil,nil);

    [string release];

    strcpy(sMemory,"0");
    strcpy(sValue[0],"0");
    strcpy(sValue[1],"0");
    dPart=0;
}

- (BOOL)checkFilePath:(char *)s
{
    struct	stat	stbuf;

    if((!lstat(s,&stbuf)))
        return FALSE;



    return TRUE;


}

- (void)checkIsZero:(char *)string
{
    char	*s;

    if(string[0] == 46)
      {
        s=strdup(string);
        sprintf(string,"0%s",s);
        free(s);
      }
}

- (BOOL)checkInString:(char *)s
{
    int i;

    for(i=0;s[i];i++)
      {
        if(!isdigit(s[i]))
          {
            if(s[i] != 46 && s[i] != 45)
              {
                return TRUE;
              }
          }
      }

    return FALSE;
         


}

- (void)cButton:(id)sender
{
    operator='C';
    [self addValues:@""];

    [outBuffer setString:@"0"];

    strcpy(sMemory,"0");
    strcpy(sValue[0],"0");
    strcpy(sValue[1],"0");
    dPart=0;
   
   
    [outField setStringValue:@"0"];//setStringValue:outBuffer];
    operator='C';
}

- (void)ceButton:(id)sender
{
    [outBuffer setString:@""];
    [self addValues:@"0"];

    [outBuffer setString:@""];
    
}

- (void)divideButton:(id)sender
{
    [self calcNow:'/'];

    if(operator)
        [self printCStringValue:sMemory];

    operator='/';

    [outBuffer setString:@""];
    dPart=1;

}

- (void)eightButton:(id)sender
{
    [self addValues:@"8"];

}



- (void)equalButton:(id)sender
{
    NSMutableString	*string=[[NSMutableString alloc]init];

    if(operator)
        lastOperator=operator;
    
    [self calcNow:'='];
    [string initWithCString:sMemory];

    [self printStringValue:string];

    [outBuffer setString:string];

    [string release];
      
  //  strcpy(sMemory,"0");
   // strcpy(sValue[0],"0");
   // strcpy(sValue[1],"0");
   // dPart=0;

}


- (void)fiveButton:(id)sender
{

   [self addValues:@"5"];
   
}

- (void)fourButton:(id)sender
{
   [self addValues:@"4"];
}

- (void)mcButton:(id)sender
{
    strcpy(backMemory,"0");
    

    [memoryField setStringValue:@""];
     
}

- (void)minusButton:(id)sender
{

    [self calcNow:'-'];

    if(operator)
        [self printCStringValue:sMemory];

    operator='-';

    [outBuffer setString:@""];
    dPart=1;
    
}

- (void)mplusButton:(id)sender
{
    char	s[100],s2[100];
    char	*retstring;
    NSString	*string;

    string=[outField stringValue];

    [string getCString:s2];
    

    sprintf(s,"%s+%s",backMemory,s2);
    retstring=[self calcBC:s];

    strcpy(backMemory,retstring);
      
}

- (void)mrButton:(id)sender
{
    NSMutableString	*ns=[[NSMutableString alloc]init];

    [ns initWithCString:backMemory];

    [self addValues:ns];

    [ns release];
    
}

- (void)msButton:(id)sender
{
    NSString	*string;

    string=[outField stringValue];

    [string getCString:backMemory];

    //NSLog(@"In msButton [%s]",backMemory);

    
   // [memoryField selectText:self];
    [memoryField setStringValue:@"M"];

   
}

- (void)multiButton:(id)sender
{

    [self calcNow:'*'];

    if(operator)
        [self printCStringValue:sMemory];

    operator='*';

    [outBuffer setString:@""];
    dPart=1;
}

- (void)nineButton:(id)sender
{
    [self addValues:@"9"];

}

- (void)oneButton:(id)sender
{
    [self addValues:@"1"];
}

- (void)oneXButton:(id)sender
{
    char	s[100],s2[100];
    NSString *string;
    char	*rets;

    string=[outField stringValue];
    [string getCString:s];

    sprintf(s2,"scale=32;1/%s",s);

    rets=[self calcBC:s2];
    strcpy(sMemory,rets);

    [self printCStringValue:rets];

    [outBuffer initWithCString:rets];

    lastOperator=operator;
    strcpy(sValue[0],sMemory);
    dPart=1;


}

- (void)percentButton:(id)sender
{
    [self calcNow:'%'];

  //  NSLog(@"In percentButton - sValue1=[%s] sValue2=[%s]",sValue[0],sValue[1]);
    
}

- (void)periodButton:(id)sender
{
    nAfterPeriod++;
    [self addValues:@"."];

    
}

- (void)plusButton:(id)sender
{
    
    [self calcNow:'+'];

    if(operator)
      {
        //NSLog(@"yep");
         [self printCStringValue:sMemory];
      }
    operator='+';

    [outBuffer setString:@""];
    dPart=1;
}

- (void)plusminusButton:(id)sender
{
    MDOUBLE	d,d2,a;
    NSMutableString *ns=[[NSMutableString alloc]init];
    char	s[100];

    a=[outField doubleValue];
    d=a;
    d2=d-(a*2);

    sprintf(s,"%.*f",MAX_AFTER_PERIOD,d2);
    rtrimZero(s);
    
    [ns initWithCString:s];
    [outBuffer setString:@""];
    [self addValues:ns];

    [ns release];
    
     
}

- (void)printCStringValue:(char *)s
{
    NSMutableString	*string=[[NSMutableString alloc]init];

    [string initWithCString:s];


    [self printStringValue:string];


    [string release];



}

- (void)printStringValue:(NSString *)string
{
    char	s[100];
    NSMutableString	*ns=[[NSMutableString alloc]init];

    //NSLog(@"outstring length =[%d] >= [%d]",[string length],MAX_AFTER_PERIOD+2);

    if([string length] >= MAX_AFTER_PERIOD)
      {
        [string getCString:s];
        s[MAX_AFTER_PERIOD]=0;
        [string initWithCString:s];
      }
   
   
    [string getCString:s];

    rtrimZero(s);
    [self checkIsZero:s];

    [ns initWithCString:s];
    
 
    [outField setStringValue:ns];

    [ns release];
}


- (void)sevenButton:(id)sender
{
    [self addValues:@"7"];

}
- (void)showInfoPanel:(id)sender
{
        [[NSApplication sharedApplication] orderFrontStandardAboutPanelWithOptions:
            [NSDictionary dictionaryWithObjectsAndKeys: @"Sucaba",@"ApplicationName",nil]];
}

- (void)sixButton:(id)sender
{
    [self addValues:@"6"];

}

- (void)sqtButton:(id)sender
{
    char	s[100];
    char	s2[100];
    char	*rets;
    NSString *string;

    string=[outField stringValue];

    [string getCString:s];

    sprintf(s2,"sqrt(%s)",s);

    rets=[self calcBC:s2];
    strcpy(sMemory,rets);

    [self printCStringValue:rets];

    [outBuffer initWithCString:rets];

    lastOperator=operator;
    strcpy(sValue[0],sMemory);
    dPart=1;
}

- (void)threeButton:(id)sender
{
    [self addValues:@"3"];

}

- (void)twoButton:(id)sender
{
    [self addValues:@"2"];

}

- (void)zeroButton:(id)sender
{
    [self addValues:@"0"];

}

- (void)awakeFromNib
{
    [outField selectText:self];
    [[outField window] makeKeyAndOrderFront:self];
}



@end
