#import "AATTileView.h"
#import "NSImage+SNExtensions.h"

static NSImage *_blankTileImage = nil;

@implementation AATTileView

+ (void) initialize
{
    NSBundle *thisBundle;

    if (self == [AATTileView class])
    {
        thisBundle = [NSBundle bundleForClass:self];
        NSAssert (thisBundle != nil, @"Could not get bundle.");

        _blankTileImage = [[NSImage imageNamed:@"BlankTile.tiff" fromBundle:thisBundle] retain];
    }
}

//----------------------------------------------------------------------

- initWithFrame:(NSRect)frameRect
{
    if ([super initWithFrame:frameRect] == nil)
        return nil;

    image = nil;
    compositePoint = NSZeroPoint;

    return self;
}

//----------------------------------------------------------------------

- (void) dealloc
{
    [image release];

    [super dealloc];
}

//----------------------------------------------------------------------

- (NSImage *) image
{
    return image;
}

//----------------------------------------------------------------------

- (void) setImage:(NSImage *)newImage
{
    NSSize imageSize;
    
    [image release];
    image = [newImage retain];

    if (image != nil)
    {
        imageSize = [newImage size];

        // Don't scale smaller images, but be sure to shrink larger ones.
        // XXX: Should we worry about proportionality?
        if (imageSize.height > 48 || imageSize.width > 48)
        {
            [image setScalesWhenResized:YES];
            [image setSize:NSMakeSize (48, 48)];
            compositePoint = NSMakePoint (8, 8);
        }
        else
        {
            compositePoint = NSMakePoint ((64 - imageSize.width) / 2, (64 - imageSize.height) / 2);
        }
    }

    [self setNeedsDisplay:YES];
}

//----------------------------------------------------------------------

- (void) drawRect:(NSRect)rect
{
    if (_blankTileImage != nil)
    {
        [_blankTileImage compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver];
    }

    if (image != nil)
    {
        [image compositeToPoint:compositePoint operation:NSCompositeSourceOver];
    }
}

@end
