// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniLibrarian/OWShelfView.h,v 1.2 1998/02/25 10:57:38 kc Exp $

#import <AppKit/NSView.h>

@class NSArray;

#import <AppKit/NSNibDeclarations.h> // For IBAction

#import "OWShelfViewDelegateProtocol.h"
#import "OWShelfViewDragSupportProtocol.h"
#import "OWShelfViewFormatterProtocol.h"

@interface OWShelfView : NSView
{
    id <OWShelfViewDelegate> delegate;
    id <OWShelfViewDragSupport> dragSupport;
    id <OWShelfViewFormatter> formatter;
    id <NSObject> *contents;
    BOOL *selected;
    NSSize spaceSize;
    unsigned int spacesAcross, spacesDown, totalSpaces;
    NSPoint dragPoint;
    id <NSObject> draggingObject, dragOutObject;
    struct {
	unsigned int moveOnDrag:1;
    } flags;
}

// setup
- (void)setSpaceSize:(NSSize)size;
- (void)setDelegate:(id <OWShelfViewDelegate>)aDelegate;
- (void)setFormatter:(id <OWShelfViewFormatter>)aFormatter;
- (void)setDragSupport:(id <OWShelfViewDragSupport>)aDragSupport;
- (void)setMoveOnDrag:(BOOL)newMoveOnDrag;
- (void)addEntry:(id <NSObject>)anEntry selected:(BOOL)isSelected atRow:(unsigned int)row andColumn:(unsigned int)column;

- (BOOL)moveOnDrag;
- (NSSize)spaceSize;
- (NSMutableArray *)selection;
- (id <OWShelfViewFormatter>)formatter;
- (id <OWShelfViewDelegate>)delegate;

- (IBAction)selectAll:(id)sender;

// Get state out for saving

- (unsigned int)rows;
- (unsigned int)columns;
- (id <NSObject>)entryAtRow:(unsigned int)aRow column:(unsigned int)aColumn;
- (BOOL)selectedAtRow:(unsigned int)aRow column:(unsigned int)aColumn;

@end
