/*
    File:       QStringList.h

    Contains:   A class for accessing Mac OS 'STR#' data structures.

    Written by: Quinn "The Eskimo!"

    Created:    Tue 20-May-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

// Explanatory Note
//
// A Mac OS string list data structure (normally found in 'STR#' resources)
// consists of a two byte count of the number of strings followed by the
// string stored as packed Pascal strings.  For example, a 'STR#' consisting
// of two strings, "frog", "womble" and "blibble", would contain the following bytes:
//
// 0x00 0x03 -- big endian two byte count
// 0x04      -- length of string 1
// "frog"    -- characters in string 1
// 0x06      -- length of string 2
// "womble"  -- characters in string 2
// 0x07      -- length of string 3
// "blibble" -- characters in string 3
//
// This data structure is a pain to parse, so I've wrapped it up inside an
// object.

@interface QStringList : NSObject
{
    NSData *listData;
}

+ (QStringList *)stringListWithData:(NSData *)theData;
    // Create a string list from theData.  theData is retained.

- (QStringList *)initWithData:(NSData *)theData;
    // Initialises a string list from theData.  theData is retained.

- (long)count;
    // Returns the number of strings in the string list.

- (NSString *)stringAtIndex:(long)index;
    // Returns the string at the index'th position in the string
    // list.  Note that index is *one based*, not zero based like the
    // the rest of the OpenStep world.  The rationale behind this is
    // that I didn't want entries in a string list to be renumbered
    // when brought between the worlds.

- (NSString *)description;
    // Overridden for debugging fun and convenience.

- (void)dealloc;
    // Overridden to allow us to release theData.

@end
