/*
    File:       QMacDataAccess.h

    Contains:   Additions to NSData for accessing common Mac OS data types.

    Written by: Quinn "The Eskimo!"

    Created:    Tue 20-May-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

#import "QMacDefines.h"

@interface NSData ( QMacDataAccess )

// The following routines read the standard Mac OS integer data types
// (as specified by signed/unsigned and the number of bits
// in the type) from the receiving NSData at the specified offset
// The offset is in bytes. The routines byte swap the data if necessary.

- (UInt32)MacUInt32AtOffset:(UInt32)offset;
- (UInt16)MacUInt16AtOffset:(UInt32)offset;
- (UInt8) MacUInt8AtOffset: (UInt32)offset;

- (SInt32)MacSInt32AtOffset:(UInt32)offset;
- (SInt16)MacSInt16AtOffset:(UInt32)offset;
- (SInt8) MacSInt8AtOffset: (UInt32)offset;

- (NSString *)MacPStringAtOffset:(UInt32)offset;
    // Read a Mac OS Pascal string from offset bytes into the receiver
    // and return it as an NSString.

- (NSRect)MacRectAtOffset:(UInt32)offset;
    // Read a Mac OS Rect structure from offset bytes into the receiver
    // and return it as an NSRect.  A Mac OS Rect is defined by four
    // consecutive SInt16s: top, left, bottom, right.  We read in those
    // four co-ordinates and convert them to the NSRect original, size
    // format.  Note that the Mac co-ordinates are integer only, so the
    // returned NSRect will never contain fractional components.

@end
