// ---------------------------------------------------------------------------
//  M88 - PC-8801 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  $Id: memmon.h,v 1.4 1999/06/28 12:08:56 cisc Exp $

#if !defined(win32_memmon_h)
#define win32_memmon_h

#include "instthnk.h"
#include "device.h"
#include "pc88/memview.h"

// ---------------------------------------------------------------------------

class PC88;

namespace PC8801
{

class MemoryMonitor
{
public:
    MemoryMonitor();
    ~MemoryMonitor();

    bool Init(PC88*);
#ifdef __OS2__
    void Show(HWND, bool show);
#else
    void Show(HINSTANCE, HWND, bool show);
#endif
    void Update();
    bool IsOpen() { return !!hwnd; }

private:
    enum
    {
        bkcol = 0x400000,
    };

#ifdef __OS2__
#else
    BOOL DlgProc(HWND, UINT, WPARAM, LPARAM);
    static BOOL _cdecl DlgProcGate(MemoryMonitor*, HWND, UINT, WPARAM, LPARAM);
    BOOL EDlgProc(HWND, UINT, WPARAM, LPARAM);
    static BOOL _cdecl EDlgProcGate(MemoryMonitor*, HWND, UINT, WPARAM, LPARAM);
#endif
    void Paint(HWND);
    void Draw(HWND, HDC);
    void DrawMain(HDC);
    void PutLine(const char*, ...);
    void SetBank();

#ifdef __OS2__
    InstanceThunk dlgproc;
    InstanceThunk edlgproc;
#endif
    HWND hwnd;
#ifdef __OS2__
#else
    HINSTANCE hinst;
#endif
    const uint8* regs;

    MemoryViewer mv;
    MemoryBus* bus;
    HDC hdc;
    int y;
    int fontheight;
    int fontwidth;
    int addr;
    int height;
    int editaddr;
    MemoryViewer::Type a0;
    MemoryViewer::Type a6;
    MemoryViewer::Type af;
};

}

#endif // !defined(win32_memmon_h)
