// ---------------------------------------------------------------------------
//	PSG Sound Implementation
//	Copyright (C) cisc 1997, 1999.
// ---------------------------------------------------------------------------
//	$Id: psg.h,v 1.2 1999/07/10 10:12:35 cisc Exp $

#ifndef PSG_H
#define PSG_H

#include "types.h"

// ---------------------------------------------------------------------------

class PSG
{
public:
	typedef int32 Sample;
	enum
	{
		noisetablesize = 1 << 10,
		toneshift = 24,
		envshift = 22,
		noiseshift = 14,
		oversampling = 2,
	};

public:
	PSG();
	~PSG();

	void Reset();
	void Mix(Sample* dest, int nsamples);
	
	void SetReg(uint regnum, uint8 data);
	void SetClock(int clock, int rate);
	uint GetReg(uint regnum) { return reg[regnum]; }
	void SetVolume(int vol);

protected:
	void MakeNoiseTable();
	void MakeEnvelopTable();
	
	uint8 reg[16];

	const uint* envelop;
	uint olevel[3];
	uint32 scount[3], speriod[3];
	uint32 ecount, eperiod;
	uint32 ncount, nperiod;
	uint32 tperiodbase;
	uint32 eperiodbase;
	uint32 nperiodbase;
	int volume;

	static uint enveloptable[16][64];
	static uint noisetable[noisetablesize];
	static int EmitTable[32];
};

#endif // PSG_H
