// ---------------------------------------------------------------------------
//	Z80 emulator in C++
//	Copyright (C) cisc 1997, 1999.
// ----------------------------------------------------------------------------
//	$Id: Z80c.h,v 1.16 1999/06/28 12:08:27 cisc Exp $

#ifndef Z80C_h
#define Z80C_h

#include "types.h"
#include "device.h"
#include "Z80.h"

class Bus;

// ----------------------------------------------------------------------------
//	Z80 Emulator
//	
//	gp\ȋ@\
//	Reset
//	INT
//	NMI
//	
//	bool Init(Bus* bus)
//	Z80 G~[^
//	in:		bus		CPU Ȃ Bus
//	out:			Ȃ true
//	
//	uint Exec(uint clk)
//	w肵NbN߂s
//	in:		clk		sNbN
//	out:			ۂɎsNbN
//	
//	int Stop(int clk)
//	scNbNύX
//	in:		clk
//
//	uint GetCount()
//	ʎZsNbNJEg擾
//	out:
//
//	void Reset()
//	Z80 CPU Zbg
//
//	void INT(int flag)
//	Z80 CPU  INT 荞ݗvo
//	in:		flag	true: 荞ݔ
//					false: 
//	
//	void NMI()
//	Z80 CPU  NMI 荞ݗvo
//	
//	void Wait(bool wait)
//	Z80 CPU ̓~
//	in:		wait	~߂ꍇ true
//					wait Ԃ̏ꍇ Exec ߂sȂ悤ɂȂ
//
class Z80C : public Device
{
public:
	enum
	{
		reset = 0, irq, nmi,
	};

public:
	Z80C(const ID& id);
	~Z80C();
	
	const Descriptor* GetDesc() const { return &descriptor; } 
	
	bool Init(Bus* bus, int iack);
	
	int  Exec(int count);
	int ExecOne();
	static int ExecSingle(Z80C* first, Z80C* second, int count);
	static int ExecDual(Z80C* first, Z80C* second, int count);
	static int ExecDual2(Z80C* first, Z80C* second, int count);
	
	void Stop(int count);
	static void StopDual(int count) { currentcpu->Stop(count); }
	int GetCount();
	static int GetCCount() { return currentcpu ? currentcpu->GetCount() - currentcpu->startcount : 0; }
	
	void Reset(uint=0, uint=0);
	void IRQ(uint, uint d) { intr = d; }
	void NMI(uint=0, uint=0);
	void Wait(bool flag);
	
	uint GetPC();
	void SetPC(uint newpc);
	Z80Reg& GetReg() { return reg; }

//	bool LoadStatus(const StatusMap&);
//	bool SaveStatus(StatusMap&);

	MemoryBus::Page* GetPages() { return pages; }
	void TestIntr();
	bool IsIntr() { return !!intr; }
	
private:
	uint8* inst;		// PC ̎w̃|C^C܂ PC ̂
	uint8* instlim;		// inst ̗L
	uint8* instbase;	// inst - PC		(PC = inst - instbase)
	uint8* instpage;
	
	Z80Reg reg;
	Bus* bus;
	static const Descriptor descriptor;
	static const OutFuncPtr outdef[];
	static Z80C* currentcpu;
	static int cbase;

	int execcount;
	int clockcount;
	int stopcount;
	int delaycount;
	int intack;
	int intr;
	int waitstate;				// b0:HALT b1:WAIT
	int eshift;
	int startcount;
	
	enum index { USEHL, USEIX, USEIY };
	index index_mode;						/* HL/IX/IY ǂQƂ邩 */
	uint8 uf;								/* vZtO */
	uint8 nfa;								/* Ō̉Z̎ */
	uint8 xf;								/* `tO(3,5rbg) */
	uint32 fx32, fy32;						/* tOvZp̃f[^ */
	uint fx, fy;
	
	uint8* ref_h[3];						/* H / XH / YH ̃e[u */
	uint8* ref_l[3];						/* L / YH / YL ̃e[u */
	Z80Reg::wordreg* ref_hl[3];				/* HL/ IX / IY ̃e[u */
	uint8* ref_byte[8];						/* BCDEHL A ̃e[u */

	MemoryBus::Page pages[0x10000 >> MemoryBus::pagebits];
	
	// C^[tF[X
private:
	uint Read8(uint addr);
	uint Read16(uint a);
	uint Fetch8();
	uint Fetch16();
	void Write8(uint addr, uint data);
	void Write16(uint a, uint d);
	uint Inp(uint port);
	void Outp(uint port, uint data);
	uint Fetch8B();
	uint Fetch16B();

	void SingleStep(uint inst);
	void SingleStep();
	void Init();
	int  Exec0(int stop, int d);
	int  Exec1(int stop, int d);
	bool Sync();

	void SetPCi(uint newpc);
	void PCInc(uint inc);
	void PCDec(uint dec);
	
	void Call(), Jump(uint dest), JumpR();
	uint8 GetCF(), GetZF(), GetSF();
	uint8 GetHF(), GetPF();
	void SetM(uint n);
	uint8 GetM();
	void Push(uint n);
	uint Pop();
	void ADDA(uint8), ADCA(uint8), SUBA(uint8);
	void SBCA(uint8), ANDA(uint8), ORA(uint8);
	void XORA(uint8), CPA(uint8);
	uint8 Inc8(uint8), Dec8(uint8);
	uint ADD16(uint x, uint y);
	void ADCHL(uint y), SBCHL(uint y);
	uint GetAF();
	void SetAF(uint n);
	void SetZS(uint8 a), SetZSP(uint8 a);
	void CPI(), CPD();
	void CodeCB();

	uint8 RLC(uint8), RRC(uint8), RL (uint8);
	uint8 RR (uint8), SLA(uint8), SRA(uint8);
	uint8 SLL(uint8), SRL(uint8);
};

// ---------------------------------------------------------------------------
//  NbNJE^擾
//
inline int Z80C::GetCount()
{
	return execcount + (clockcount << eshift);
}

inline uint Z80C::GetPC()
{
	return inst - instbase;
}

#endif // Z80C.h
