/* $Id: Configure.cmd,v 1.1 2001/04/14 16:22:09 sandervl Exp $
 *
 * Configuration script.
 * Generates global makefile.inc.
 *
 * Copyright (c) 1999-2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 * Project Odin Software License can be found in LICENSE.TXT
 *
 */
    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
    call SysLoadFuncs;

    /* check for silent argument */
    parse arg fNonInteractive
    if (fNonInteractive <> '') then
        fInteractive = 0;
    else
        fInteractive = 1;

    /* strings */
    sIncFile='Makefile.inc';

    /* Status */
    if (fInteractive) then
        say 'Configuring the SBLive driver...';


    /* delete old makefile.inc file */
    call SysFileDelete sIncFile;

    /* open target file */
    if (stream(sIncFile, 'c', 'open write' ) <> '') then
    do
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# Generated by 'directory()'\configure.cmd'
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, ''
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# sblive basedirectories'
        call lineout sIncFile, '# Note! These should be absolute paths!'
        call lineout sIncFile, '################################################################################'
        sOdin32Base = directory();
        call lineout sIncFile, 'SBLIVE_BASE      =' sOdin32Base;
        call lineout sIncFile, 'SBLIVE_SRC       =' sOdin32Base'\src';
        call lineout sIncFile, 'SBLIVE_LIB_      =' sOdin32Base'\lib';
        call lineout sIncFile, 'SBLIVE_BIN_      =' sOdin32Base'\bin';
        call lineout sIncFile, 'SBLIVE_INCLUDE   =' sOdin32Base'\include';
        call lineout sIncFile, 'SBLIVE_TOOLS     =' sOdin32Base'\tools';
        call lineout sIncFile, ''
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# Include the sblive.mk file'
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '!ifdef 32BIT'
        call lineout sIncFile, '!include 'sOdin32Base'\include\sblive32.mk'
        call lineout sIncFile, '!else'
        call lineout sIncFile, '!include 'sOdin32Base'\include\sblive16.mk'
        call lineout sIncFile, '!endif'
        call lineout sIncFile, ''

        call stream sIncFile, 'c', 'close';


        call directory(sOldDir);


        /*
         * Display start info.
         */
        if (fInteractive = 1) then
        do
            say 'Configuration completed!'
            say ''
            say 'To build the SBLive driver do:'
            say '   WMAKE -f makefile.os2 /ms'
        end
    end
    else
    do
        say 'oops, failed to open outputfile,' sIncFile;
        exit 1;
    end
    exit 0;



/*****************/
/* function area */
/*****************/


/**
 * SearchPaths
 * Parameters:
 *   Takes pair of <envionment variable name> and <filename> as parameters
 *   As final optional parameter you may specify a question to request the string from the user.
 * Returns:
 *   sPath-sFile ignoring '..\'s in sFile.
 */
SearchPaths: procedure expose fInteractive;
    i = 1;
    sEnv  = arg(i);
    sFile = arg(i+1);
    sPath = '';
    do while (sPath == '' & sEnv <> '' & sFile <> '')
        sPath = SysSearchPath(sEnv, sFile);
        /* debug: say 'sEnv:'sEnv 'sFile:'sFile 'sPath:'sPath 'i:'i */
        i = i + 2;
        sEnv  = arg(i);
        sFile = arg(i+1);
    end

    if (sPath == '' & sEnv <> '' & sFile == '') then
    do
        say sEnv;
        if (fInteractive = 1) then
            sPath = linein();
        else
            say '!ignored!';
    end
    else
    do
        if sPath <> '' then do
            /*  */
            i = lastpos('..\', sFile);
            if i <> 0 then
                sFile = substr(sFile, i + 2);

            /* cut equally */
            i = lastpos(sFile, sPath);
            if i == 0 then
                say '!error! sFile:'sFile  'sPath:'sPath;
            /* debug: say 'sPath:'sPath  'sFile:'sFile */
            sPath = substr(sPath, 1, i-1);
        end
    end

    return sPath;
