/*
 * Copyright 2009 Vasilkin Andrew <digi@os2.snc.ru>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. The name of the author may not be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LQLIB_H
#define LQLIB_H

#define INCL_BASE
#define INCL_DOSSEMAPHORES
#define INCL_DOSNMPIPES
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>

#define PIPE_CMD_STAT		"STAT"
#define PIPE_CMD_STAT_COMPACT	"STAT2"
#define PIPE_REPLY_EOF		"!EOF"

typedef long long		LLONG, *PLLONG;
typedef unsigned long long	ULLONG, *PULLONG;

typedef BOOL FNPIPEWRITESTAT(HPIPE hPipe, PCHAR pcBuf, BOOL fCompact);
typedef FNPIPEWRITESTAT *PFNPIPEWRITESTAT;

typedef struct _LQPIPE {
  HPIPE			hPipe;
  TID			tidPipeServ;
  PFNPIPEWRITESTAT	pfnPipeWriteStat;
  PSZ			pszPipeName;
} LQPIPE, *PLQPIPE;


ULONG lqlibPipeServInit(PLQPIPE pLQPipe, PSZ pszPipeName,
                        PFNPIPEWRITESTAT pfnPipeWriteStat);
VOID lqlibPipeServDone(PLQPIPE pLQPipe);
ULONG lqlibPipeWriteMessage(HPIPE hPipe, PSZ pszMessage);

ULONG lqlibEASetLLong(PSZ pszPath, PSZ pszEAName, LLONG llData);
ULONG lqlibEAQueryLLong(PSZ pszPath, PSZ pszEAName, PLLONG pllData);

#endif // LQLIB_H
