# ifndef yyDefinitions
# define yyDefinitions

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif


# ifndef bool
# define bool char
# endif
# define NoDefinitions (tDefinitions) 0L
# define kScopes 1
# define kSCOPE_LIST 2
# define kSCOPE_EMPTY 3
# define kEntries 4
# define kENTRY_LIST 5
# define kENTRY_EMPTY 6
# define kObject 7
# define kVarObject 8
# define kTemplateObject 9
# define kProcessorsObject 10
# define kTypeObject 11
# define kProcObject 12
# define kFuncObject 13
# define kBlockObject 14
# define kModuleObject 15
# define kCommonObject 16
# define kNameListObject 17
# define kDistribution 18
# define kDefaultDistribution 19
# define kArrayUseDistribution 20
# define kSerialDistribution 21
# define kHostDistribution 22
# define kNodeDistribution 23
# define kAlignDistribution 24
# define kVarDescription 25
# define kVarDummy 26
# define kVarConstant 27
# define kVarLocal 28
# define kVarCommon 29

typedef unsigned char Definitions_tKind;
typedef unsigned short Definitions_tMark;
typedef unsigned short Definitions_tLabel;
typedef union Definitions_Node * tDefinitions;
typedef void (* Definitions_tProcTree) ();
/* line 22 "definitions.cg" */


# define FORTRAN

# define arr_illegal      -1
# define arr_fixed_size    0
# define arr_automatic     1
# define arr_allocatable   2
# define arr_assumed_size  3

# define NoObject       NoDefinitions

# define tDistribution  tDefinitions  /* type for distributions            */
# define tObject        tDefinitions  /* type for object descriptors       */
# define tEntries       tDefinitions  /* type to represent sets of decls.  */
# define tScopes        tDefinitions  /* type to represent scopes          */

# include "Idents.h"
# include "Tree.h"
# include "global.h"     /* MAX_DIMENSIONS */

    /*****************************************
    *                                        *
    *  Arrays for distributed dimensions     *
    *                                        *
    *****************************************/

typedef struct {
     int no_dims;
     int DimsArray [MAX_DIMENSIONS];
     } DistributedDimensions;

    /*****************************************
    *                                        *
    *  Searching Objects                     *
    *                                        *
    *****************************************/

/* searching in a given Scope */

tObject GetDeclEntry ARGS((tIdent Ident, tEntries Decls));

/* searching in last scope : ScopeList */

tObject GetLocalDecl ARGS((tIdent Ident));

/* searching in all scopes : ScopeList */

tObject GetGlobalDecl ARGS((tIdent Ident));

/* searching in Unit/External/Intrinsic Subrouitines */

tObject GetOtherDecl ARGS((tIdent Ident));

    /*****************************************
    *                                        *
    *  Handling Scopes                       *
    *                                        *
    *****************************************/

void NewScope ();                        /* opening new empty scope */

void OpenScope ARGS((tEntries Entries)); /* open given scope */

void CloseScope (/* */);                 /* close last scope */

tEntries GetCurrentScope ();             /* get the current Scope */

tEntries GetExternalEntries ();          /* get Scope with Externals  */
tEntries GetIntrinsicEntries ();         /* get Scope with Intrinsics */
tEntries GetUnitEntries ();              /* get Scope with Units      */
tEntries GetCommonEntries ();            /* get Scope with Commons    */

    /***********************************
    *                                  *
    *    Inserting Entries             *
    *                                  *
    ************************************/

void InsertUnitEntry ARGS((tObject Obj));

void InsertExternalEntry ARGS((tObject Obj));

void InsertCommonEntry ARGS((tObject Obj));

void InsertEntry ARGS((tObject Obj));

    /***********************************
    *                                  *
    *    Changing Entries              *
    *                                  *
    ************************************/

void ChangeEntry ARGS((tIdent Name, tObject Obj));

    /***********************************
    *                                  *
    *  Some Constants used             *
    *                                  *
    ************************************/

#define IntentIn     0
#define IntentOut    1
#define IntentInOut  2



# ifndef Definitions_NodeHead
# define Definitions_NodeHead
# endif
typedef struct { Definitions_tKind yyKind; Definitions_tMark yyMark; Definitions_NodeHead } Definitions_tNodeHead;
typedef struct { Definitions_tNodeHead yyHead; } yScopes;
typedef struct { Definitions_tNodeHead yyHead; tDefinitions Table; tDefinitions Hidden; } ySCOPE_LIST;
typedef struct { Definitions_tNodeHead yyHead; } ySCOPE_EMPTY;
typedef struct { Definitions_tNodeHead yyHead; } yEntries;
typedef struct { Definitions_tNodeHead yyHead; tDefinitions Elem; tDefinitions Next; } yENTRY_LIST;
typedef struct { Definitions_tNodeHead yyHead; } yENTRY_EMPTY;
typedef struct { Definitions_tNodeHead yyHead; tIdent ident; tTree decl; } yObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent ident; tTree decl; tDefinitions Kind; int uses; tDefinitions Dist; } yVarObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent ident; tTree decl; tDefinitions Dist; } yTemplateObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent ident; tTree decl; } yProcessorsObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent ident; tTree decl; tDefinitions Components; } yTypeObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent ident; tTree decl; int calls; tDefinitions Declarations; } yProcObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent ident; tTree decl; int calls; tDefinitions Declarations; } yFuncObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent ident; tTree decl; tDefinitions Declarations; } yBlockObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent ident; tTree decl; int uses; tDefinitions Declarations; } yModuleObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent ident; tTree decl; int size; int main; int distributed_vars; int sequence; } yCommonObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent ident; tTree decl; } yNameListObject;
typedef struct { Definitions_tNodeHead yyHead; int size; int helpvars; } yDistribution;
typedef struct { Definitions_tNodeHead yyHead; int size; int helpvars; } yDefaultDistribution;
typedef struct { Definitions_tNodeHead yyHead; int size; int helpvars; } yArrayUseDistribution;
typedef struct { Definitions_tNodeHead yyHead; int size; int helpvars; } ySerialDistribution;
typedef struct { Definitions_tNodeHead yyHead; int size; int helpvars; tIdent hostdist_id; } yHostDistribution;
typedef struct { Definitions_tNodeHead yyHead; int size; int helpvars; tIdent nodedist_id; DistributedDimensions dims; } yNodeDistribution;
typedef struct { Definitions_tNodeHead yyHead; int size; int helpvars; tObject template; DistributedDimensions dims; } yAlignDistribution;
typedef struct { Definitions_tNodeHead yyHead; } yVarDescription;
typedef struct { Definitions_tNodeHead yyHead; int Intent; int dynamic; bool optional; } yVarDummy;
typedef struct { Definitions_tNodeHead yyHead; tTree Val; tTree Type; } yVarConstant;
typedef struct { Definitions_tNodeHead yyHead; int IsSave; int dynamic; } yVarLocal;
typedef struct { Definitions_tNodeHead yyHead; tIdent Block; } yVarCommon;

union Definitions_Node {
 Definitions_tKind Kind;
 Definitions_tNodeHead yyHead;
 yScopes Scopes;
 ySCOPE_LIST SCOPE_LIST;
 ySCOPE_EMPTY SCOPE_EMPTY;
 yEntries Entries;
 yENTRY_LIST ENTRY_LIST;
 yENTRY_EMPTY ENTRY_EMPTY;
 yObject Object;
 yVarObject VarObject;
 yTemplateObject TemplateObject;
 yProcessorsObject ProcessorsObject;
 yTypeObject TypeObject;
 yProcObject ProcObject;
 yFuncObject FuncObject;
 yBlockObject BlockObject;
 yModuleObject ModuleObject;
 yCommonObject CommonObject;
 yNameListObject NameListObject;
 yDistribution Distribution;
 yDefaultDistribution DefaultDistribution;
 yArrayUseDistribution ArrayUseDistribution;
 ySerialDistribution SerialDistribution;
 yHostDistribution HostDistribution;
 yNodeDistribution NodeDistribution;
 yAlignDistribution AlignDistribution;
 yVarDescription VarDescription;
 yVarDummy VarDummy;
 yVarConstant VarConstant;
 yVarLocal VarLocal;
 yVarCommon VarCommon;
};

extern tDefinitions DefinitionsRoot;
extern unsigned long Definitions_HeapUsed;
extern char * Definitions_PoolFreePtr, * Definitions_PoolMaxPtr;
extern unsigned short Definitions_NodeSize [29 + 1];
extern char * Definitions_NodeName [29 + 1];

extern tDefinitions Definitions_Alloc ();
extern tDefinitions MakeDefinitions ARGS((Definitions_tKind yyKind));
extern bool Definitions_IsType ARGS((register tDefinitions yyt, register Definitions_tKind yyKind));

extern tDefinitions mScopes ARGS(());
extern tDefinitions mSCOPE_LIST ARGS((tDefinitions pTable, tDefinitions pHidden));
extern tDefinitions mSCOPE_EMPTY ARGS(());
extern tDefinitions mEntries ARGS(());
extern tDefinitions mENTRY_LIST ARGS((tDefinitions pElem, tDefinitions pNext));
extern tDefinitions mENTRY_EMPTY ARGS(());
extern tDefinitions mObject ARGS((tIdent pident, tTree pdecl));
extern tDefinitions mVarObject ARGS((tIdent pident, tTree pdecl, tDefinitions pKind, int puses, tDefinitions pDist));
extern tDefinitions mTemplateObject ARGS((tIdent pident, tTree pdecl, tDefinitions pDist));
extern tDefinitions mProcessorsObject ARGS((tIdent pident, tTree pdecl));
extern tDefinitions mTypeObject ARGS((tIdent pident, tTree pdecl, tDefinitions pComponents));
extern tDefinitions mProcObject ARGS((tIdent pident, tTree pdecl, int pcalls, tDefinitions pDeclarations));
extern tDefinitions mFuncObject ARGS((tIdent pident, tTree pdecl, int pcalls, tDefinitions pDeclarations));
extern tDefinitions mBlockObject ARGS((tIdent pident, tTree pdecl, tDefinitions pDeclarations));
extern tDefinitions mModuleObject ARGS((tIdent pident, tTree pdecl, int puses, tDefinitions pDeclarations));
extern tDefinitions mCommonObject ARGS((tIdent pident, tTree pdecl, int psize, int pmain, int pdistributed_vars, int psequence));
extern tDefinitions mNameListObject ARGS((tIdent pident, tTree pdecl));
extern tDefinitions mDistribution ARGS((int psize, int phelpvars));
extern tDefinitions mDefaultDistribution ARGS((int psize, int phelpvars));
extern tDefinitions mArrayUseDistribution ARGS((int psize, int phelpvars));
extern tDefinitions mSerialDistribution ARGS((int psize, int phelpvars));
extern tDefinitions mHostDistribution ARGS((int psize, int phelpvars, tIdent phostdist_id));
extern tDefinitions mNodeDistribution ARGS((int psize, int phelpvars, tIdent pnodedist_id, DistributedDimensions pdims));
extern tDefinitions mAlignDistribution ARGS((int psize, int phelpvars, tObject ptemplate, DistributedDimensions pdims));
extern tDefinitions mVarDescription ARGS(());
extern tDefinitions mVarDummy ARGS((int pIntent, int pdynamic, bool poptional));
extern tDefinitions mVarConstant ARGS((tTree pVal, tTree pType));
extern tDefinitions mVarLocal ARGS((int pIsSave, int pdynamic));
extern tDefinitions mVarCommon ARGS((tIdent pBlock));

extern void BeginDefinitions ();
extern void CloseDefinitions ();

# endif
